/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import org.springframework.xd.dirt.job.dsl.Flow;
import org.springframework.xd.dirt.job.dsl.JobDefinition;
import org.springframework.xd.dirt.job.dsl.JobNode;
import org.springframework.xd.dirt.job.dsl.JobReference;
import org.springframework.xd.dirt.job.dsl.JobSpecification;
import org.springframework.xd.dirt.job.dsl.Split;

public abstract class JobSpecificationVisitor<T> {
    protected void accept(JobSpecification jobSpec) {
        T context = this.preJobSpecWalk();
        JobNode jn = jobSpec.getJobNode();
        if (jn != null) {
            context = this.walk(context, jn);
        }
        this.postJobSpecWalk(context, jobSpec);
    }

    public final T walk(T context, JobNode jn) {
        if (jn instanceof Flow) {
            return this.walk(context, (Flow)jn);
        }
        if (jn instanceof JobDefinition) {
            return this.walk(context, (JobDefinition)jn);
        }
        if (jn instanceof JobReference) {
            return this.walk(context, (JobReference)jn);
        }
        if (jn instanceof Split) {
            return this.walk(context, (Split)jn);
        }
        throw new IllegalStateException("nyi:" + jn.getClass().getName());
    }

    public T preJobSpecWalk() {
        return null;
    }

    public void postJobSpecWalk(T context, JobSpecification jobSpec) {
    }

    public abstract T walk(T var1, Flow var2);

    public abstract T walk(T var1, JobDefinition var2);

    public abstract T walk(T var1, JobReference var2);

    public abstract T walk(T var1, Split var2);
}

