/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.springframework.xd.dirt.job.dsl.ArgumentNode;
import org.springframework.xd.dirt.job.dsl.AstNode;
import org.springframework.xd.dirt.job.dsl.Flow;
import org.springframework.xd.dirt.job.dsl.Graph;
import org.springframework.xd.dirt.job.dsl.JobDefinition;
import org.springframework.xd.dirt.job.dsl.JobDescriptor;
import org.springframework.xd.dirt.job.dsl.JobNode;
import org.springframework.xd.dirt.job.dsl.JobReference;
import org.springframework.xd.dirt.job.dsl.JobSpecificationVisitor;
import org.springframework.xd.dirt.job.dsl.Link;
import org.springframework.xd.dirt.job.dsl.Node;
import org.springframework.xd.dirt.job.dsl.Split;
import org.springframework.xd.dirt.job.dsl.Transition;
import org.springframework.xd.dirt.stream.JobDefinitionRepository;
import org.springframework.xml.transform.StringResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JobSpecification
extends AstNode {
    private String jobDefinitionText;
    private JobNode jobNode;
    private List<JobDefinition> jobDefinitions;
    private ArgumentNode[] globalOptions;

    public JobSpecification(String jobDefinitionText, JobNode jobNode, ArgumentNode[] globalOptions) {
        super(jobNode == null ? 0 : jobNode.getStartPos(), jobNode == null ? 0 : jobNode.getEndPos());
        this.jobDefinitionText = jobDefinitionText;
        this.jobNode = jobNode;
        this.globalOptions = globalOptions;
    }

    public Map<String, String> getGlobalOptionsMap() {
        if (this.globalOptions == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        for (ArgumentNode option : this.globalOptions) {
            optionsMap.put(option.getName(), option.getValue());
        }
        return optionsMap;
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        StringBuilder s = new StringBuilder();
        s.append(this.jobNode.stringify(includePositionInfo));
        if (this.globalOptions != null) {
            for (ArgumentNode option : this.globalOptions) {
                s.append(" ");
                s.append(option.stringify(includePositionInfo));
            }
        }
        return s.toString();
    }

    public String getJobDefinitionText() {
        return this.jobDefinitionText;
    }

    public JobNode getJobNode() {
        return this.jobNode;
    }

    public List<JobDefinition> getJobDefinitions() {
        if (this.jobDefinitions != null) {
            return this.jobDefinitions;
        }
        JobDefinitionLocator jdl = new JobDefinitionLocator();
        jdl.accept(this);
        this.jobDefinitions = jdl.getJobDefinitions();
        return this.jobDefinitions;
    }

    public List<JobReference> getJobReferences() {
        JobReferenceLocator jrl = new JobReferenceLocator();
        jrl.accept(this);
        return jrl.getJobReferences();
    }

    public void validate(JobDefinitionRepository jobDefinitionRepository) {
    }

    public Graph toGraph() {
        GraphGeneratorVisitor ggv = new GraphGeneratorVisitor();
        ggv.accept(this);
        return ggv.getGraph();
    }

    public String toXML(String batchJobId) {
        return this.toXML(batchJobId, false);
    }

    public String toXML(String batchJobId, boolean prettyPrint) {
        XMLGeneratorVisitor xgv = new XMLGeneratorVisitor(batchJobId, prettyPrint);
        xgv.accept(this);
        return xgv.getXmlString();
    }

    public JobDefinition getJobDefinition(String jobName) {
        for (JobDefinition jd : this.getJobDefinitions()) {
            if (!jd.getJobName().equals(jobName)) continue;
            return jd;
        }
        return null;
    }

    public String format() {
        return this.jobNode.format(0);
    }

    static class GraphGeneratorVisitor
    extends JobSpecificationVisitor<int[]> {
        private int id = 0;
        private Map<String, Node> createdNodes = new HashMap<String, Node>();
        private Stack<Context> contexts = new Stack();
        private List<Node> nodes = new ArrayList<Node>();
        private List<Link> links = new ArrayList<Link>();
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        GraphGeneratorVisitor() {
        }

        public Graph getGraph() {
            Graph g = new Graph(this.nodes, this.links, this.properties);
            return g;
        }

        @Override
        public int[] preJobSpecWalk() {
            Node node = new Node(Integer.toString(this.id++), "START");
            this.nodes.add(node);
            this.contexts.push(new Context(false));
            return new int[]{0};
        }

        @Override
        public void postJobSpecWalk(int[] finalNodes, JobSpecification jobSpec) {
            int endId = this.id++;
            Node endNode = new Node(Integer.toString(endId), "END");
            this.nodes.add(endNode);
            this.contexts.pop();
            for (int i : finalNodes) {
                Node incomingNode = this.findNodeById(i);
                if (incomingNode.name.equals("END")) {
                    List<Link> linksToUpdate = this.getLinksTo(i);
                    for (Link link : linksToUpdate) {
                        link.updateTo(Integer.toString(endId));
                    }
                    this.nodes.remove(incomingNode);
                    continue;
                }
                this.links.add(new Link(i, endId));
            }
            Map<String, String> options = jobSpec.getGlobalOptionsMap();
            if (options.size() != 0) {
                for (Map.Entry<String, String> option : options.entrySet()) {
                    this.properties.put(option.getKey(), option.getValue());
                }
            }
        }

        @Override
        public int[] walk(int[] context, Flow jn) {
            int[] result = context;
            this.contexts.push(new Context(true));
            ArrayList<String> jobsNamedInFlow = new ArrayList<String>();
            for (JobNode j : jn.getSeries()) {
                if (!(j instanceof JobDescriptor)) continue;
                jobsNamedInFlow.add(((JobDescriptor)j).getName());
            }
            this.contexts.peek().setJobsInFlow(jobsNamedInFlow);
            Iterator<JobNode> seriesIterator = jn.getSeries().iterator();
            while (seriesIterator.hasNext()) {
                JobNode j;
                j = seriesIterator.next();
                if (!seriesIterator.hasNext()) {
                    this.contexts.peek().isEndOfFlow = true;
                }
                result = this.walk(result, j);
            }
            List<Integer> exits = this.contexts.pop().flowExits;
            for (int r : result) {
                exits.add(r);
            }
            result = this.toIntArray(exits);
            return result;
        }

        @Override
        public int[] walk(int[] context, Split pjs) {
            int[] inputContext = context;
            if (inputContext.length > 1) {
                int nextId = this.id++;
                Node node = new Node(Integer.toString(nextId), "SYNC");
                this.nodes.add(node);
                for (int i : inputContext) {
                    Link l = new Link(i, nextId);
                    this.links.add(l);
                }
                inputContext = new int[]{nextId};
            }
            int[] result = new int[]{};
            for (JobNode jn : pjs.getSeries()) {
                this.contexts.push(new Context(false));
                int[] outputContext = this.walk(inputContext, jn);
                this.contexts.pop();
                result = this.merge(result, outputContext);
            }
            return result;
        }

        @Override
        public int[] walk(int[] context, JobReference jr) {
            int nextId;
            Node node;
            Node existingNode;
            LinkedHashMap<String, String> properties = null;
            ArgumentNode[] args = jr.getArguments();
            if (args != null && args.length != 0) {
                properties = new LinkedHashMap<String, String>();
                for (ArgumentNode arg : args) {
                    properties.put(arg.getName(), arg.getValue());
                }
            }
            if ((existingNode = this.contexts.peek().nodesSharedInFlow.get(jr.getName())) != null) {
                node = existingNode;
                nextId = Integer.parseInt(existingNode.id);
            } else {
                nextId = this.id++;
                node = new Node(Integer.toString(nextId), jr.getName(), null, properties);
                this.nodes.add(node);
            }
            this.createdNodes.put(jr.getName(), node);
            if (context != null) {
                int[] s;
                for (int i : s = context) {
                    Link l = new Link(i, nextId);
                    this.links.add(l);
                }
            }
            boolean explicitWildcardUsed = false;
            boolean isMappingExitSpace = false;
            ArrayList<Integer> allExitsToReturn = new ArrayList<Integer>();
            if (jr.hasTransitions()) {
                isMappingExitSpace = true;
                List<Integer> flowExits = this.contexts.peek().flowExits;
                for (Transition t : jr.getTransitions()) {
                    String targetJobName;
                    String jobExitStatus;
                    int transitionTargetId;
                    if (t.getStateNameInDSLForm().equals("'*'")) {
                        explicitWildcardUsed = true;
                    }
                    if ((transitionTargetId = this.buildTransition(nextId, jobExitStatus = t.getStateNameInDSLForm(), targetJobName = t.getTargetJobName())) == -1 || this.isForwardReferenceInFlow(targetJobName)) continue;
                    if (flowExits != null) {
                        flowExits.add(transitionTargetId);
                        continue;
                    }
                    allExitsToReturn.add(transitionTargetId);
                }
            }
            if (isMappingExitSpace) {
                if (!explicitWildcardUsed && !this.contexts.peek().isEndOfFlow && this.contexts.peek().flowExits != null) {
                    allExitsToReturn.add(nextId);
                }
            } else {
                allExitsToReturn.add(nextId);
            }
            return this.toIntArray(allExitsToReturn);
        }

        int[] merge(int[] input, Object additional) {
            int[] additionalArrayData = (int[])additional;
            int[] result = new int[input.length + additionalArrayData.length];
            System.arraycopy(input, 0, result, 0, input.length);
            System.arraycopy(additionalArrayData, 0, result, input.length, additionalArrayData.length);
            return result;
        }

        public Node findNodeInList(List<Integer> nodesInScope, String name) {
            if (nodesInScope != null) {
                for (Integer i : nodesInScope) {
                    for (Node n : this.nodes) {
                        if (!n.id.equals(i) || !n.name.equals(name)) continue;
                        return n;
                    }
                }
            }
            return null;
        }

        private boolean isForwardReferenceInFlow(String searchJobName) {
            List<String> jobsInFlow = this.contexts.peek().jobsInFlow;
            if (jobsInFlow != null) {
                for (String jobname : jobsInFlow) {
                    if (!jobname.equals(searchJobName)) continue;
                    return true;
                }
            }
            return false;
        }

        private int buildTransition(int fromJobNodeId, String jobExitStatus, String targetJobName) {
            int transitionTargetId;
            boolean createdNewTarget = false;
            if (targetJobName.equals("$FAIL")) {
                targetJobName = "FAIL";
            } else if (targetJobName.equals("$END")) {
                targetJobName = "END";
            }
            Node targetNode = this.contexts.peek().nodesSharedInFlow.get(targetJobName);
            if (targetNode == null) {
                transitionTargetId = this.id++;
                targetNode = new Node(Integer.toString(transitionTargetId), targetJobName);
                this.nodes.add(targetNode);
                createdNewTarget = true;
            } else {
                transitionTargetId = Integer.parseInt(targetNode.id);
            }
            this.links.add(new Link(fromJobNodeId, transitionTargetId, jobExitStatus));
            this.contexts.peek().nodesSharedInFlow.put(targetJobName, targetNode);
            return createdNewTarget ? transitionTargetId : -1;
        }

        @Override
        public int[] walk(int[] context, JobDefinition jd) {
            return new int[0];
        }

        private List<Link> getLinksTo(int i) {
            ArrayList<Link> result = new ArrayList<Link>();
            for (Link link : this.links) {
                if (i != Integer.parseInt(link.to)) continue;
                result.add(link);
            }
            return result;
        }

        private Node findNodeById(int i) {
            for (Node node : this.nodes) {
                if (Integer.parseInt(node.id) != i) continue;
                return node;
            }
            return null;
        }

        private int[] toIntArray(List<Integer> integers) {
            int[] result = new int[integers.size()];
            for (int i = 0; i < integers.size(); ++i) {
                result[i] = integers.get(i);
            }
            return result;
        }

        static class Context {
            boolean isEndOfFlow = false;
            List<Integer> flowExits;
            Map<String, Node> nodesSharedInFlow = new LinkedHashMap<String, Node>();
            List<String> jobsInFlow;

            Context(boolean inFlow) {
                if (inFlow) {
                    this.flowExits = new ArrayList<Integer>();
                }
            }

            public void setJobsInFlow(List<String> jobsNamedInFlow) {
                this.jobsInFlow = jobsNamedInFlow;
            }
        }
    }

    static class XMLGeneratorVisitor
    extends JobSpecificationVisitor<Element[]> {
        private Document doc;
        private Element batchJobElement;
        private boolean prettyPrint;
        private Stack<Element> currentElement = new Stack();
        private int splitIdCounter = 1;
        private List<String> jobRunnerBeanNames = new ArrayList<String>();
        private Stack<Map<String, String>> transitionNamesToElementIdsInFlow = new Stack();
        private Map<JobReference, String> jobReferencesToElementIds = new LinkedHashMap<JobReference, String>();
        private String xmlString;
        private String batchJobId;
        private List<String> allocatedStepIds = new ArrayList<String>();

        XMLGeneratorVisitor(String batchJobId, boolean prettyPrint) {
            this.batchJobId = batchJobId;
            this.prettyPrint = prettyPrint;
        }

        @Override
        protected void accept(JobSpecification jobSpec) {
            List<JobReference> jobReferences = jobSpec.getJobReferences();
            for (JobReference jr : jobReferences) {
                this.jobReferencesToElementIds.put(jr, this.getNextStepId(jr.getName()));
            }
            super.accept(jobSpec);
        }

        public String getXmlString() {
            return this.xmlString;
        }

        @Override
        public Element[] preJobSpecWalk() {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                DOMImplementation domImplementation = db.getDOMImplementation();
                this.doc = domImplementation.createDocument("http://www.springframework.org/schema/beans", "beans", null);
                this.doc.createElementNS("http://www.springframework.org/schema/batch", "batch");
                this.doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:batch", "http://www.springframework.org/schema/batch");
                this.doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.doc.getDocumentElement().setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/batch http://www.springframework.org/schema/batch/spring-batch.xsd");
                this.doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.springframework.org/schema/beans");
                Element taskExecutor = this.doc.createElement("bean");
                this.doc.getDocumentElement().appendChild(taskExecutor);
                taskExecutor.setAttribute("id", "taskExecutor");
                taskExecutor.setAttribute("class", "org.springframework.core.task.SimpleAsyncTaskExecutor");
                this.batchJobElement = this.doc.createElement("batch:job");
                this.doc.getDocumentElement().appendChild(this.batchJobElement);
                this.batchJobElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.springframework.org/schema/batch");
                if (this.batchJobId != null) {
                    this.batchJobElement.setAttribute("id", this.batchJobId);
                }
                this.transitionNamesToElementIdsInFlow.push(new LinkedHashMap());
                this.currentElement.push(this.batchJobElement);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected problem building XML representation", e);
            }
            return null;
        }

        private boolean isMappingExitSpace(Element step) {
            NodeList children = step.getChildNodes();
            for (int c = 0; c < children.getLength(); ++c) {
                String nodeName = children.item(c).getNodeName();
                if (!nodeName.equals("next") && !nodeName.equals("end") && !nodeName.equals("fail")) continue;
                return true;
            }
            return false;
        }

        private boolean isMappingExitStatus(Element step, String exitStatus) {
            NodeList children = step.getChildNodes();
            for (int c = 0; c < children.getLength(); ++c) {
                String onAttributeValue;
                String nodeName = children.item(c).getNodeName();
                if (!nodeName.equals("next") && !nodeName.equals("end") && !nodeName.equals("fail") || !(onAttributeValue = children.item(c).getAttributes().getNamedItem("on").getNodeValue()).equals(exitStatus)) continue;
                return true;
            }
            return false;
        }

        private void addNextAttribute(Element step, String jobExitStatus, String targetId) {
            Element next = this.doc.createElement("next");
            next.setAttribute("on", jobExitStatus);
            next.setAttribute("to", targetId);
            step.appendChild(next);
        }

        private void addFailAttribute(Element step, String jobExitStatus) {
            Element fail = this.doc.createElement("fail");
            fail.setAttribute("on", jobExitStatus);
            step.appendChild(fail);
        }

        private void addEndAttribute(Element step, String jobExitStatus) {
            Element fail = this.doc.createElement("end");
            fail.setAttribute("on", jobExitStatus);
            step.appendChild(fail);
        }

        @Override
        public void postJobSpecWalk(Element[] elements, JobSpecification jobSpec) {
            if (elements != null) {
                for (Element element : elements) {
                    if (!this.isMappingExitSpace(element) || this.isMappingExitStatus(element, "*")) continue;
                    this.addFailAttribute(element, "*");
                }
            }
            Map<String, String> transitionStepsToCreate = this.transitionNamesToElementIdsInFlow.pop();
            for (Map.Entry<String, String> transitionStepToCreate : transitionStepsToCreate.entrySet()) {
                Element step = this.createStep(transitionStepToCreate.getValue(), transitionStepToCreate.getKey());
                this.currentElement.peek().appendChild(step);
            }
            HashSet<String> generatedBeans = new HashSet<String>();
            for (String jobRunnerBeanName : this.jobRunnerBeanNames) {
                if (generatedBeans.contains(jobRunnerBeanName)) continue;
                Element bean = this.doc.createElement("bean");
                bean.setAttribute("scope", "step");
                bean.setAttribute("class", "org.springframework.xd.dirt.batch.tasklet.JobLaunchingTasklet");
                bean.setAttribute("id", "jobRunner-" + jobRunnerBeanName);
                this.addConstructorArg(bean, "ref", "messageBus");
                this.addConstructorArg(bean, "ref", "jobDefinitionRepository");
                this.addConstructorArg(bean, "ref", "xdJobRepository");
                this.addConstructorArg(bean, "value", jobRunnerBeanName);
                this.addConstructorArg(bean, "value", "${timeout}");
                this.doc.getElementsByTagName("beans").item(0).appendChild(bean);
                generatedBeans.add(jobRunnerBeanName);
            }
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                if (this.prettyPrint) {
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                }
                DOMSource source = new DOMSource(this.doc);
                StringResult sr = new StringResult();
                transformer.transform(source, (Result)sr);
                this.xmlString = sr.toString().trim();
            }
            catch (TransformerException e) {
                throw new IllegalStateException("Unexpected problem building XML representation", e);
            }
        }

        private void addConstructorArg(Element bean, String attributeName, String argName) {
            Element ctorArgElement = this.doc.createElement("constructor-arg");
            ctorArgElement.setAttribute(attributeName, argName);
            bean.appendChild(ctorArgElement);
        }

        @Override
        public Element[] walk(Element[] context, Flow jn) {
            boolean inSplit = this.currentElement.peek().getTagName().equals("split");
            if (inSplit) {
                Element flow = this.doc.createElement("flow");
                this.currentElement.peek().appendChild(flow);
                this.currentElement.push(flow);
            }
            Element[] result = context;
            this.transitionNamesToElementIdsInFlow.push(new LinkedHashMap());
            for (JobNode j : jn.getSeries()) {
                result = this.walk(result, j);
            }
            Map<String, String> transitionStepsToCreate = this.transitionNamesToElementIdsInFlow.pop();
            for (Map.Entry<String, String> transitionStepToCreate : transitionStepsToCreate.entrySet()) {
                Element step = this.createStep(transitionStepToCreate.getValue(), transitionStepToCreate.getKey());
                this.currentElement.peek().appendChild(step);
            }
            if (inSplit) {
                this.currentElement.pop();
            }
            return result;
        }

        @Override
        public Element[] walk(Element[] context, JobDefinition jd) {
            Element step = this.doc.createElement("step");
            step.setAttribute("id", jd.getJobName());
            Element tasklet = this.doc.createElement("tasklet");
            String jobRunnerId = "jobRunner-" + jd.getJobName();
            tasklet.setAttribute("ref", jobRunnerId);
            this.jobRunnerBeanNames.add(jd.getName());
            step.appendChild(tasklet);
            Element next = null;
            if (jd.hasTransitions()) {
                for (Transition t : jd.transitions) {
                    if (t.getTargetJobName().equals("$FAIL")) {
                        this.addFailAttribute(step, t.getStateName());
                        continue;
                    }
                    if (t.getTargetJobName().equals("$END")) {
                        this.addEndAttribute(step, t.getStateName());
                        continue;
                    }
                    this.addNextAttribute(step, t.getStateName(), t.getTargetJobName());
                }
            }
            if (context != null) {
                Element[] elements;
                for (Element element : elements = context) {
                    next = this.doc.createElement("next");
                    next.setAttribute("on", "COMPLETED");
                    next.setAttribute("to", jd.getJobName());
                    element.appendChild(next);
                }
            }
            this.currentElement.peek().appendChild(step);
            return new Element[]{step};
        }

        private String getNextStepId(String prefix) {
            if (!this.allocatedStepIds.contains(prefix)) {
                this.allocatedStepIds.add(prefix);
                return prefix;
            }
            int suffix = 1;
            String proposal = null;
            while (this.allocatedStepIds.contains(proposal = prefix + Integer.toString(suffix++))) {
            }
            this.allocatedStepIds.add(proposal);
            return proposal;
        }

        @Override
        public Element[] walk(Element[] context, JobReference jr) {
            Element[] elementArray;
            boolean inSplit = this.currentElement.peek().getTagName().equals("split");
            if (inSplit) {
                Element flow = this.doc.createElement("flow");
                this.currentElement.peek().appendChild(flow);
                this.currentElement.push(flow);
            }
            String stepId = this.jobReferencesToElementIds.get(jr);
            Element step = this.createStep(stepId, jr.getName());
            this.currentElement.peek().appendChild(step);
            this.jobRunnerBeanNames.add(jr.getName());
            boolean explicitWildcardExit = false;
            if (jr.hasTransitions()) {
                for (Transition t : jr.transitions) {
                    String targetJob;
                    if (t.getStateName().equals("*")) {
                        explicitWildcardExit = true;
                    }
                    if ((targetJob = t.getTargetJobName()).equals("$END")) {
                        this.addEndAttribute(step, t.getStateName());
                        continue;
                    }
                    if (targetJob.equals("$FAIL")) {
                        this.addFailAttribute(step, t.getStateName());
                        continue;
                    }
                    Map<String, String> transitionNamesToElementIdsInCurrentFlow = this.transitionNamesToElementIdsInFlow.peek();
                    if (transitionNamesToElementIdsInCurrentFlow.containsKey(targetJob)) {
                        targetJob = transitionNamesToElementIdsInCurrentFlow.get(targetJob);
                    } else {
                        String id = this.getReferenceToExistingJob(targetJob);
                        if (id == null) {
                            id = this.getNextStepId(targetJob);
                            transitionNamesToElementIdsInCurrentFlow.put(targetJob, id);
                            if (inSplit) {
                                Element transitionStep = this.createStep(id, t.getTargetJobName());
                                this.currentElement.peek().appendChild(transitionStep);
                            }
                        }
                        targetJob = id;
                    }
                    this.addNextAttribute(step, t.getStateName(), targetJob);
                    this.jobRunnerBeanNames.add(t.getTargetJobName());
                }
                if (inSplit && !this.isMappingExitStatus(step, "*")) {
                    this.addFailAttribute(step, "*");
                }
            }
            if (context != null) {
                for (Element element : context) {
                    this.addNextAttribute(element, "COMPLETED", stepId);
                    if (this.isMappingExitStatus(element, "*")) continue;
                    this.addFailAttribute(element, "*");
                }
            }
            if (inSplit) {
                this.currentElement.pop();
            }
            if (explicitWildcardExit) {
                elementArray = new Element[]{};
            } else {
                Element[] elementArray2 = new Element[1];
                elementArray = elementArray2;
                elementArray2[0] = step;
            }
            return elementArray;
        }

        @Override
        public Element[] walk(Element[] context, Split pjs) {
            Element split = this.doc.createElement("split");
            String splitId = "split" + this.splitIdCounter++;
            split.setAttribute("task-executor", "taskExecutor");
            split.setAttribute("id", splitId);
            if (context != null) {
                for (Element element : context) {
                    this.addNextAttribute(element, "COMPLETED", splitId);
                    if (this.isMappingExitStatus(element, "*")) continue;
                    this.addFailAttribute(element, "*");
                }
            }
            this.currentElement.peek().appendChild(split);
            this.currentElement.push(split);
            Element[] inputContext = new Element[]{};
            Element[] result = new Element[]{};
            for (JobNode jn : pjs.getSeries()) {
                this.transitionNamesToElementIdsInFlow.push(new LinkedHashMap());
                Element[] outputContext = this.walk(inputContext, jn);
                this.transitionNamesToElementIdsInFlow.pop();
                result = this.merge(result, outputContext);
            }
            this.currentElement.pop();
            return new Element[]{split};
        }

        private Element[] merge(Element[] input, Object additional) {
            Element[] additionalArrayData = (Element[])additional;
            Element[] result = new Element[input.length + additionalArrayData.length];
            System.arraycopy(input, 0, result, 0, input.length);
            System.arraycopy(additionalArrayData, 0, result, input.length, additionalArrayData.length);
            return result;
        }

        private Element createStep(String stepId, String jobRunnerBeanIdSuffix) {
            Element step = this.doc.createElement("step");
            step.setAttribute("id", stepId);
            Element tasklet = this.doc.createElement("tasklet");
            tasklet.setAttribute("ref", "jobRunner-" + jobRunnerBeanIdSuffix);
            step.appendChild(tasklet);
            return step;
        }

        private String getReferenceToExistingJob(String jobName) {
            for (Map.Entry<JobReference, String> jrEntry : this.jobReferencesToElementIds.entrySet()) {
                if (!jrEntry.getKey().getName().equals(jobName)) continue;
                return jrEntry.getValue();
            }
            return null;
        }
    }

    static class JobReferenceLocator
    extends JobSpecificationVisitor<Object> {
        List<JobReference> jobReferences = new ArrayList<JobReference>();

        JobReferenceLocator() {
        }

        public List<JobReference> getJobReferences() {
            return this.jobReferences;
        }

        @Override
        public Object walk(Object context, Flow sjs) {
            for (JobNode jobNode : sjs.getSeries()) {
                this.walk(context, jobNode);
            }
            return context;
        }

        @Override
        public Object walk(Object context, JobDefinition jd) {
            return context;
        }

        @Override
        public Object walk(Object context, JobReference jr) {
            this.jobReferences.add(jr);
            return context;
        }

        @Override
        public Object walk(Object context, Split pjs) {
            for (JobNode jobNode : pjs.getSeries()) {
                this.walk(context, jobNode);
            }
            return context;
        }
    }

    static class JobDefinitionLocator
    extends JobSpecificationVisitor<Object> {
        List<JobDefinition> jobDefinitions = new ArrayList<JobDefinition>();

        JobDefinitionLocator() {
        }

        public List<JobDefinition> getJobDefinitions() {
            return this.jobDefinitions;
        }

        @Override
        public Object walk(Object context, Flow sjs) {
            for (JobNode jobNode : sjs.getSeries()) {
                this.walk(context, jobNode);
            }
            return context;
        }

        @Override
        public Object walk(Object context, JobDefinition jd) {
            this.jobDefinitions.add(jd);
            return context;
        }

        @Override
        public Object walk(Object context, JobReference jr) {
            return context;
        }

        @Override
        public Object walk(Object context, Split pjs) {
            for (JobNode jobNode : pjs.getSeries()) {
                this.walk(context, jobNode);
            }
            return context;
        }
    }
}

