/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import org.springframework.xd.dirt.job.dsl.ArgumentNode;
import org.springframework.xd.dirt.job.dsl.JobDescriptor;
import org.springframework.xd.dirt.job.dsl.Token;
import org.springframework.xd.dirt.job.dsl.Transition;

public class JobReference
extends JobDescriptor {
    private Token jobReference;

    public JobReference(Token jobReference, ArgumentNode[] args) {
        super(jobReference.startpos, jobReference.endpos, args);
        this.jobReference = jobReference;
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        StringBuilder s = new StringBuilder();
        if (includePositionInfo) {
            s.append(this.jobReference.stringValue()).append("[").append(this.getStartPos()).append(">").append(this.getEndPos()).append("]");
        } else {
            s.append(this.jobReference.stringValue());
        }
        if (this.args != null) {
            for (ArgumentNode arg : this.args) {
                s.append(" ");
                s.append(arg.stringify(includePositionInfo));
            }
        }
        if (this.hasTransitions()) {
            for (Transition t : this.transitions) {
                s.append(" ");
                s.append(t.stringify(includePositionInfo));
            }
        }
        return s.toString();
    }

    @Override
    public String toString() {
        return "JobReference: " + this.stringify(true);
    }

    @Override
    public final boolean isReference() {
        return true;
    }

    @Override
    public String getName() {
        return this.jobReference.stringValue();
    }
}

