/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.xd.dirt.job.dsl.ArgumentNode;
import org.springframework.xd.dirt.job.dsl.Flow;
import org.springframework.xd.dirt.job.dsl.Graph;
import org.springframework.xd.dirt.job.dsl.JobDSLMessage;
import org.springframework.xd.dirt.job.dsl.JobDefinition;
import org.springframework.xd.dirt.job.dsl.JobDescriptor;
import org.springframework.xd.dirt.job.dsl.JobNode;
import org.springframework.xd.dirt.job.dsl.JobReference;
import org.springframework.xd.dirt.job.dsl.JobSpecification;
import org.springframework.xd.dirt.job.dsl.JobSpecificationException;
import org.springframework.xd.dirt.job.dsl.Split;
import org.springframework.xd.dirt.job.dsl.Token;
import org.springframework.xd.dirt.job.dsl.TokenKind;
import org.springframework.xd.dirt.job.dsl.Tokens;
import org.springframework.xd.dirt.job.dsl.Transition;

public class JobParser {
    static final boolean SUPPORTS_INLINE_JOB_DEFINITIONS = false;
    private Tokens tokens;

    public JobSpecification parse(String jobSpecification) {
        if ((jobSpecification = jobSpecification.trim()).length() == 0) {
            return new JobSpecification(jobSpecification, null, null);
        }
        this.tokens = new Tokens(jobSpecification);
        JobNode jobNode = this.parseJobNode();
        ArgumentNode[] globalOptions = this.maybeEatModuleArgs();
        JobSpecification js = new JobSpecification(jobSpecification, jobNode, globalOptions);
        if (this.tokens.hasNext()) {
            throw new JobSpecificationException(this.tokens.getExpression(), this.tokens.peek().startpos, JobDSLMessage.UNEXPECTED_DATA_AFTER_JOBSPEC, JobParser.toString(this.tokens.next()));
        }
        return js;
    }

    private JobNode parseJobNode() {
        if (this.tokens.maybeEat(TokenKind.OPEN_PAREN)) {
            JobNode jn = this.parseJobNode();
            this.tokens.eat(TokenKind.CLOSE_PAREN);
            return jn;
        }
        if (this.tokens.peek(TokenKind.SPLIT_OPEN)) {
            JobNode jn = this.parseSplit();
            return this.maybeParseFlow(jn);
        }
        JobDescriptor jd = this.parseJobDescriptor();
        return this.maybeParseFlow(jd);
    }

    private JobNode maybeParseFlow(JobNode firstJobNodeInFlow) {
        if (this.tokens.peek(TokenKind.DOUBLE_PIPE)) {
            ArrayList<JobNode> jobNodes = new ArrayList<JobNode>();
            jobNodes.add(firstJobNodeInFlow);
            while (this.tokens.maybeEat(TokenKind.DOUBLE_PIPE)) {
                JobNode nextNode = this.parseJobNode();
                if (nextNode instanceof Flow) {
                    jobNodes.addAll(nextNode.getSeries());
                    continue;
                }
                jobNodes.add(nextNode);
            }
            return new Flow(jobNodes);
        }
        return firstJobNodeInFlow;
    }

    private JobNode parseSplit() {
        ArrayList<JobNode> flows = new ArrayList<JobNode>();
        this.tokens.eat(TokenKind.SPLIT_OPEN);
        flows.add(this.parseJobNode());
        while (this.tokens.maybeEat(TokenKind.AMPERSAND)) {
            flows.add(this.parseJobNode());
        }
        this.tokens.eat(TokenKind.SPLIT_CLOSE);
        return new Split(flows);
    }

    private JobDescriptor parseJobDescriptor() {
        JobReference jd = null;
        if (this.tokens.peek(0, TokenKind.IDENTIFIER)) {
            if (this.tokens.peek(1, TokenKind.IDENTIFIER)) {
                this.tokens.raiseException(this.tokens.peek((int)1).startpos, JobDSLMessage.EXPECTED_FLOW_OR_SPLIT_CHARS, this.tokens.peek(1).stringValue());
            } else {
                jd = this.parseJobReference(false);
            }
        }
        if (jd == null) {
            Token t = this.tokens.peek();
            this.tokens.raiseException(t == null ? 0 : t.startpos, JobDSLMessage.EXPECTED_JOB_REF_OR_DEF, new Object[0]);
        }
        if (this.tokens.peek(TokenKind.PIPE)) {
            List<Transition> transitions = this.parseTransitions();
            jd.setTransitions(transitions);
        }
        return jd;
    }

    private List<Transition> parseTransitions() {
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        while (this.tokens.maybeEat(TokenKind.PIPE)) {
            Token nextToken;
            Token transitionName = this.tokens.next();
            if (!transitionName.isKind(TokenKind.IDENTIFIER) && !transitionName.isKind(TokenKind.LITERAL_STRING)) {
                this.tokens.raiseException(transitionName.startpos, JobDSLMessage.EXPECTED_TRANSITION_NAME, this.tokenToString(transitionName));
            }
            if ((nextToken = this.tokens.peek()) == null) {
                this.tokens.raiseException(transitionName.endpos - 1, JobDSLMessage.MISSING_EQUALS_AFTER_TRANSITION_NAME, this.tokenToString(transitionName));
            }
            if (!nextToken.isKind(TokenKind.EQUALS)) {
                this.tokens.raiseException(nextToken.startpos, JobDSLMessage.EXPECTED_EQUALS_AFTER_TRANSITION_NAME, this.tokenToString(nextToken));
            } else {
                this.tokens.next();
            }
            JobReference targetJobReference = this.parseJobReference(false);
            transitions.add(new Transition(transitionName, targetJobReference));
        }
        return transitions;
    }

    private String tokenToString(Token token) {
        return token.stringValue() == null ? new String(token.kind.tokenChars) : token.stringValue();
    }

    private JobReference parseJobReference(boolean allowArguments) {
        Token jobDefinitionNameToken = this.tokens.eat(TokenKind.IDENTIFIER);
        this.tokens.checkpoint();
        ArgumentNode[] args = null;
        if (allowArguments) {
            args = this.maybeEatModuleArgs();
        }
        return new JobReference(jobDefinitionNameToken, args);
    }

    private JobDefinition parseJobDefinition() {
        Token jobModuleNameToken = this.tokens.eat(TokenKind.IDENTIFIER);
        Token jobName = this.tokens.eat(TokenKind.IDENTIFIER);
        this.tokens.checkpoint();
        ArgumentNode[] args = this.maybeEatModuleArgs();
        return new JobDefinition(jobModuleNameToken, jobName, args);
    }

    private ArgumentNode[] maybeEatModuleArgs() {
        ArrayList<ArgumentNode> args = null;
        if (this.tokens.peek(TokenKind.DOUBLE_MINUS) && this.tokens.isNextAdjacent()) {
            this.tokens.raiseException(this.tokens.peek().startpos, JobDSLMessage.EXPECTED_WHITESPACE_AFTER_NAME_BEFORE_ARGUMENT, new Object[0]);
        }
        while (this.tokens.peek(TokenKind.DOUBLE_MINUS)) {
            Token argName;
            Token dashDash = this.tokens.next();
            if (this.tokens.peek(TokenKind.IDENTIFIER) && !this.tokens.isNextAdjacent()) {
                this.tokens.raiseException(this.tokens.peek().startpos, JobDSLMessage.NO_WHITESPACE_BEFORE_ARG_NAME, new Object[0]);
            }
            if (!(argName = this.tokens.next()).isKind(TokenKind.IDENTIFIER)) {
                this.tokens.raiseException(argName.startpos, JobDSLMessage.NOT_EXPECTED_TOKEN, argName.data != null ? argName.data : new String(argName.getKind().tokenChars));
            }
            if (this.tokens.peek(TokenKind.EQUALS) && !this.tokens.isNextAdjacent()) {
                this.tokens.raiseException(this.tokens.peek().startpos, JobDSLMessage.NO_WHITESPACE_BEFORE_ARG_EQUALS, new Object[0]);
            }
            this.tokens.eat(TokenKind.EQUALS);
            if (this.tokens.peek(TokenKind.IDENTIFIER) && !this.tokens.isNextAdjacent()) {
                this.tokens.raiseException(this.tokens.peek().startpos, JobDSLMessage.NO_WHITESPACE_BEFORE_ARG_VALUE, new Object[0]);
            }
            Token t = this.tokens.peek();
            String argValue = this.eatArgValue();
            this.tokens.checkpoint();
            if (args == null) {
                args = new ArrayList<ArgumentNode>();
            }
            args.add(new ArgumentNode(argName.data, argValue, dashDash.startpos, t.endpos));
        }
        return args == null ? null : args.toArray(new ArgumentNode[args.size()]);
    }

    private String eatArgValue() {
        Token t = this.tokens.next();
        String argValue = null;
        if (t.getKind() == TokenKind.IDENTIFIER) {
            argValue = t.data;
        } else if (t.getKind() == TokenKind.LITERAL_STRING) {
            String quotesUsed = t.data.substring(0, 1);
            argValue = t.data.substring(1, t.data.length() - 1).replace(quotesUsed + quotesUsed, quotesUsed);
        } else {
            this.tokens.raiseException(t.startpos, JobDSLMessage.EXPECTED_ARGUMENT_VALUE, t.data);
        }
        return argValue;
    }

    private static String toString(Token t) {
        if (t.getKind().hasPayload()) {
            return t.stringValue();
        }
        return new String(t.kind.getTokenChars());
    }

    public Graph getGraph(String jobSpecification) {
        JobSpecification js = this.parse(jobSpecification);
        return js.toGraph();
    }

    public String getXML(String batchJobId, String jobSpecification) {
        JobSpecification js = this.parse(jobSpecification);
        return js.toXML(batchJobId);
    }

    public String toString() {
        return this.tokens.toString();
    }
}

