/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import org.springframework.xd.dirt.job.dsl.ArgumentNode;
import org.springframework.xd.dirt.job.dsl.JobDescriptor;
import org.springframework.xd.dirt.job.dsl.Token;
import org.springframework.xd.dirt.job.dsl.Transition;

public class JobDefinition
extends JobDescriptor {
    private Token jobModuleId;
    private Token jobNameId;

    public JobDefinition(Token jobModuleId, Token jobNameId, ArgumentNode[] args) {
        super(jobModuleId.startpos, jobNameId.endpos, args);
        this.jobModuleId = jobModuleId;
        this.jobNameId = jobNameId;
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        StringBuilder s = new StringBuilder();
        s.append(this.jobModuleId.stringValue()).append(" ").append(this.jobNameId.stringValue());
        if (this.args != null) {
            for (ArgumentNode arg : this.args) {
                s.append(" ");
                s.append(arg.stringify(includePositionInfo));
            }
        }
        if (this.hasTransitions()) {
            for (Transition t : this.transitions) {
                s.append(" ");
                s.append(t.stringify(includePositionInfo));
            }
        }
        return s.toString();
    }

    @Override
    public final boolean isDefinition() {
        return true;
    }

    public String getJobModuleName() {
        return this.jobModuleId.stringValue();
    }

    public String getJobName() {
        return this.jobNameId.stringValue();
    }

    @Override
    public String getName() {
        return this.getJobName();
    }
}

