/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import java.text.MessageFormat;

public enum JobDSLMessage {
    UNEXPECTED_DATA_AFTER_JOBSPEC(Kind.ERROR, 200, "Found unexpected data after job specification: ''{0}''"),
    NO_WHITESPACE_BEFORE_ARG_NAME(Kind.ERROR, 201, "No whitespace allowed between '--' and option name"),
    NO_WHITESPACE_BEFORE_ARG_EQUALS(Kind.ERROR, 202, "No whitespace allowed after argument name and before '='"),
    NO_WHITESPACE_BEFORE_ARG_VALUE(Kind.ERROR, 203, "No whitespace allowed after '=' and before option value"),
    EXPECTED_ARGUMENT_VALUE(Kind.ERROR, 204, "Expected an argument value but was ''{0}''"),
    MISSING_CHARACTER(Kind.ERROR, 205, "missing expected character ''{0}''"),
    NOT_EXPECTED_TOKEN(Kind.ERROR, 206, "Unexpected token.  Expected ''{0}'' but was ''{1}''"),
    OOD(Kind.ERROR, 207, "Unexpectedly ran out of input"),
    UNEXPECTED_DATA(Kind.ERROR, 208, "unexpected data in job definition ''{0}''"),
    EXPECTED_WHITESPACE_AFTER_NAME_BEFORE_ARGUMENT(Kind.ERROR, 209, "expected whitespace after job name and before argument"),
    NO_WHITESPACE_IN_DOTTED_NAME(Kind.ERROR, 210, "No whitespace is allowed between dot and components of a name"),
    MISSING_JOB_NAME_IN_INLINEJOBDEF(Kind.ERROR, 211, "The job module must be followed by the job name before any job arguments"),
    EXPECTED_TRANSITION_NAME(Kind.ERROR, 212, "Expected the name of a job exit state but found ''{0}''"),
    EXPECTED_EQUALS_AFTER_TRANSITION_NAME(Kind.ERROR, 213, "Expected an equals after a job exit state but found ''{0}''"),
    NON_TERMINATING_QUOTED_STRING(Kind.ERROR, 214, "Cannot find terminating '' for string"),
    NON_TERMINATING_DOUBLE_QUOTED_STRING(Kind.ERROR, 215, "Cannot find terminating \" for string"),
    UNEXPECTED_ESCAPE_CHAR(Kind.ERROR, 216, "unexpected escape character."),
    MISSING_EQUALS_AFTER_TRANSITION_NAME(Kind.ERROR, 217, "Expected an equals after the transition ''{0}''"),
    ONLY_ONE_AMPERSAND_REQUIRED(Kind.ERROR, 218, "Only a single '&' is required between jobs in a split"),
    EXPECTED_JOB_REF_OR_DEF(Kind.ERROR, 19, "Expected job reference or definition"),
    JOB_REF_DOES_NOT_SUPPORT_OPTIONS(Kind.ERROR, 220, "The job reference ''{0}'' used here does not allow options"),
    EXPECTED_FLOW_OR_SPLIT_CHARS(Kind.ERROR, 221, "Expected flow '||' or split '&' next, not ''{0}''");

    private Kind kind;
    private int code;
    private String message;

    private JobDSLMessage(Kind kind, int code, String message) {
        this.kind = kind;
        this.code = code;
        this.message = message;
    }

    public String formatMessage(int pos, Object ... inserts) {
        StringBuilder formattedMessage = new StringBuilder();
        formattedMessage.append("XD").append(this.code);
        formattedMessage.append("E");
        formattedMessage.append(":");
        if (pos != -1) {
            formattedMessage.append("(pos ").append(pos).append("): ");
        }
        formattedMessage.append(MessageFormat.format(this.message, inserts));
        return formattedMessage.toString();
    }

    public Kind getKind() {
        return this.kind;
    }

    public static enum Kind {
        INFO,
        WARNING,
        ERROR;

    }
}

