/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.xd.dirt.job.dsl.Link;
import org.springframework.xd.dirt.job.dsl.Node;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Graph {
    public List<Node> nodes;
    public List<Link> links;
    public Map<String, String> properties;

    Graph() {
        this.nodes = new ArrayList<Node>();
        this.links = new ArrayList<Link>();
        this.properties = null;
    }

    Graph(List<Node> nodes, List<Link> links, Map<String, String> properties) {
        this.nodes = nodes;
        this.links = links;
        this.properties = properties == null || properties.size() == 0 ? null : properties;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "Graph:  nodes=#" + this.nodes.size() + "  links=#" + this.links.size() + "\n" + this.nodes + "\n" + this.links;
    }

    public String toJSON() {
        Graph g = new Graph(this.nodes, this.links, this.properties);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return mapper.writeValueAsString((Object)g);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected problem creating JSON from Graph", e);
        }
    }

    public String toDSLText() {
        StringBuilder graphText = new StringBuilder();
        ArrayList<Node> unvisitedNodes = new ArrayList<Node>();
        ArrayList<Link> unfollowedLinks = new ArrayList<Link>();
        unvisitedNodes.addAll(this.nodes);
        unfollowedLinks.addAll(this.links);
        Node start = this.findNodeByName("START");
        unvisitedNodes.remove(start);
        Node end = this.findNodeByName("END");
        unvisitedNodes.remove(end);
        Node fail = this.findNodeByName("FAIL");
        if (fail != null) {
            unvisitedNodes.remove(fail);
        }
        if (start == null || end == null) {
            throw new IllegalStateException("Graph is malformed - problems finding START and END nodes");
        }
        List<Link> toFollow = this.findLinksFrom(start, false);
        this.followLinks(graphText, toFollow, null, unvisitedNodes, unfollowedLinks);
        if (unvisitedNodes.size() != 0) {
            for (int loopCount = 0; unvisitedNodes.size() != 0 && loopCount < 10000; ++loopCount) {
                Node nextHead = this.findAHead(unvisitedNodes, unfollowedLinks);
                unvisitedNodes.remove(nextHead);
                toFollow = this.findLinksFrom(nextHead, false);
                if (toFollow.size() == 0) continue;
                graphText.append(" || ");
                this.printNode(graphText, nextHead, unvisitedNodes);
                this.followLinks(graphText, toFollow, null, unvisitedNodes, unfollowedLinks);
            }
        }
        if (this.properties != null) {
            for (Map.Entry<String, String> property : this.properties.entrySet()) {
                graphText.append(" --").append(property.getKey()).append("=").append(property.getValue());
            }
        }
        return graphText.toString();
    }

    private Node findAHead(List<Node> unvisitedNodes, List<Link> unvisitedLinks) {
        if (unvisitedNodes.size() == 0) {
            return null;
        }
        Node candidate = unvisitedNodes.get(0);
        boolean changedCandidate = true;
        while (changedCandidate) {
            changedCandidate = false;
            for (Link link : unvisitedLinks) {
                if (link.to != candidate.id) continue;
                changedCandidate = true;
                candidate = this.findNodeById(link.from);
            }
        }
        return candidate;
    }

    private void followLinks(StringBuilder graphText, List<Link> toFollow, Node nodeToTerminateFollow, List<Node> unvisitedNodes, List<Link> unfollowedLinks) {
        while (toFollow.size() != 0) {
            if (toFollow.size() > 1) {
                if (graphText.length() != 0) {
                    graphText.append(" || ");
                }
                graphText.append("<");
                Node endOfSplit = this.findEndOfSplit(toFollow);
                for (int i = 0; i < toFollow.size(); ++i) {
                    if (i > 0) {
                        graphText.append(" & ");
                    }
                    Link l = toFollow.get(i);
                    this.followLink(graphText, l, endOfSplit, unvisitedNodes, unfollowedLinks);
                }
                graphText.append(">");
                if (endOfSplit == null || endOfSplit.isEnd() || endOfSplit == nodeToTerminateFollow) break;
                unvisitedNodes.remove(endOfSplit);
                if (!endOfSplit.isSync()) {
                    graphText.append(" || ");
                    this.printNode(graphText, endOfSplit, unvisitedNodes);
                    List<Link> transitionalLinks = this.findLinksFrom(endOfSplit, false);
                    this.printTransitions(graphText, unvisitedNodes, unfollowedLinks, transitionalLinks, null);
                }
                toFollow = this.findLinksFromWithoutTransitions(endOfSplit, false);
                continue;
            }
            if (toFollow.size() != 1) continue;
            Link linkToFollow = toFollow.get(0);
            Node linkToFollowTarget = this.findNodeById(linkToFollow.to);
            if (linkToFollowTarget == nodeToTerminateFollow) break;
            if (graphText.length() != 0) {
                graphText.append(" || ");
            }
            this.followLink(graphText, linkToFollow, nodeToTerminateFollow, unvisitedNodes, unfollowedLinks);
            break;
        }
    }

    private Node findEndOfSplit(List<Link> toFollow) {
        if (toFollow.size() == 0) {
            return null;
        }
        if (toFollow.size() == 1) {
            return this.findNodeById(toFollow.get((int)0).to);
        }
        Link link = toFollow.get(0);
        Node nextCandidate = this.findNodeById(link.to);
        while (nextCandidate != null) {
            boolean allLinksLeadToTheCandidate = true;
            for (int l = 1; l < toFollow.size(); ++l) {
                if (this.foundInChain(toFollow.get(l), nextCandidate)) continue;
                allLinksLeadToTheCandidate = false;
                break;
            }
            if (allLinksLeadToTheCandidate) {
                return nextCandidate;
            }
            List<Link> links = this.findLinksFrom(nextCandidate, true);
            if (links.size() == 0) {
                nextCandidate = null;
                continue;
            }
            if (links.size() == 1) {
                nextCandidate = this.findNodeById(links.get((int)0).to);
                continue;
            }
            if (this.countLinksWithoutTransitions(links) == 0 || this.countLinksWithoutTransitions(links) == 1) {
                nextCandidate = this.findNodeById(links.get((int)0).to);
                continue;
            }
            while (this.countLinksWithoutTransitions(links) > 1) {
                nextCandidate = this.findEndOfSplit(links);
                links = this.findLinksFrom(nextCandidate, true);
            }
        }
        throw new IllegalStateException("Unable to find end of split");
    }

    private boolean foundInChain(Link link, Node candidate) {
        String targetId = link.to;
        Node targetNode = this.findNodeById(targetId);
        if (targetNode == candidate) {
            return true;
        }
        List<Link> outboundLinks = this.findLinksFrom(targetNode, true);
        for (Link lnk : outboundLinks) {
            if (!this.foundInChain(lnk, candidate)) continue;
            return true;
        }
        return false;
    }

    private int countLinksWithoutTransitions(List<Link> links) {
        int count = 0;
        for (Link link : links) {
            if (link.hasTransitionSet()) continue;
            ++count;
        }
        return count;
    }

    private void printNode(StringBuilder graphText, Node node, List<Node> unvisitedNodes) {
        block5: {
            block4: {
                unvisitedNodes.remove(node);
                if (node.metadata == null || !node.metadata.containsKey("jobModuleName")) break block4;
                graphText.append(node.metadata.get("jobModuleName")).append(" ");
                graphText.append(node.name).append(" ");
                if (node.properties == null) break block5;
                int count = 0;
                for (Map.Entry<String, String> entry : node.properties.entrySet()) {
                    if (count > 0) {
                        graphText.append(" ");
                    }
                    graphText.append("--").append(entry.getKey()).append("=").append(entry.getValue());
                    ++count;
                }
                break block5;
            }
            String nameInDSL = node.name;
            graphText.append(nameInDSL);
            if (node.properties != null) {
                for (Map.Entry<String, String> entry : node.properties.entrySet()) {
                    graphText.append(" ");
                    graphText.append("--").append(entry.getKey()).append("=").append(entry.getValue());
                }
            }
        }
    }

    private void followLink(StringBuilder graphText, Link link, Node nodeToFinishFollowingAt, List<Node> unvisitedNodes, List<Link> unfollowedLinks) {
        unfollowedLinks.remove(link);
        Node target = this.findNodeById(link.to);
        this.printNode(graphText, target, unvisitedNodes);
        List<Link> toFollow = this.findLinksFrom(target, false);
        this.printTransitions(graphText, unvisitedNodes, unfollowedLinks, toFollow, nodeToFinishFollowingAt);
        this.followLinks(graphText, toFollow, nodeToFinishFollowingAt, unvisitedNodes, unfollowedLinks);
    }

    private void printTransitions(StringBuilder graphText, List<Node> unvisitedNodes, List<Link> unfollowedLinks, List<Link> toFollow, Node nodeToFinishFollowingAt) {
        Iterator<Link> iterator = toFollow.iterator();
        while (iterator.hasNext()) {
            Link l = iterator.next();
            if (!l.hasTransitionSet()) continue;
            String transitionName = l.getTransitionName();
            Node transitionTarget = this.findNodeById(l.to);
            String transitionTargetName = transitionTarget.name;
            if (transitionTargetName.equals("FAIL")) {
                transitionTargetName = "$FAIL";
            } else if (transitionTargetName.equals("END")) {
                transitionTargetName = "$END";
            }
            graphText.append(" | ").append(transitionName).append(" = ").append(transitionTargetName);
            unfollowedLinks.remove(l);
            List<Link> linksFromTheTransitionTarget = this.findLinksFrom(transitionTarget, false);
            if (linksFromTheTransitionTarget.isEmpty() || this.allLinksTarget(linksFromTheTransitionTarget, nodeToFinishFollowingAt)) {
                unvisitedNodes.remove(transitionTarget);
            }
            iterator.remove();
        }
    }

    private boolean allLinksTarget(List<Link> linksFromTheTransitionTarget, Node nodeToFinishFollowingAt) {
        if (nodeToFinishFollowingAt == null) {
            return false;
        }
        for (Link link : linksFromTheTransitionTarget) {
            if (link.to.equals(nodeToFinishFollowingAt.id)) continue;
            return false;
        }
        return true;
    }

    private Node findNodeById(String id) {
        for (Node n : this.nodes) {
            if (!n.id.equals(id)) continue;
            return n;
        }
        return null;
    }

    private Node findNodeByName(String name) {
        for (Node n : this.nodes) {
            if (!n.name.equals(name)) continue;
            return n;
        }
        return null;
    }

    private List<Link> findLinksFromWithoutTransitions(Node n, boolean includeThoseLeadingToEnd) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.from.equals(n.id) || (link.hasTransitionSet() || !includeThoseLeadingToEnd && this.findNodeById((String)link.to).name.equals("END")) && (!link.hasTransitionSet() || !link.getTransitionName().equals("'*'"))) continue;
            result.add(link);
        }
        return result;
    }

    private List<Link> findLinksFrom(Node n, boolean includeThoseLeadingToEnd) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.from.equals(n.id) || !includeThoseLeadingToEnd && this.findNodeById((String)link.to).name.equals("END") && link.properties == null) continue;
            result.add(link);
        }
        return result;
    }
}

