/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import java.util.Collections;
import java.util.List;
import org.springframework.xd.dirt.job.dsl.JobNode;
import org.springframework.xd.dirt.job.dsl.JobSeries;
import org.springframework.xd.dirt.job.dsl.TokenKind;

public class Flow
extends JobSeries {
    private List<JobNode> series;

    public Flow(List<JobNode> jobDefOrRefsWithConditions) {
        super(jobDefOrRefsWithConditions.get(0).getStartPos(), jobDefOrRefsWithConditions.get(jobDefOrRefsWithConditions.size() - 1).getEndPos());
        this.series = Collections.unmodifiableList(jobDefOrRefsWithConditions);
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.series.size(); ++i) {
            if (i > 0) {
                s.append(" ").append(TokenKind.DOUBLE_PIPE.getTokenString()).append(" ");
            }
            s.append(this.series.get(i).stringify(includePositionInfo));
        }
        return s.toString();
    }

    @Override
    public int getSeriesLength() {
        return this.series.size();
    }

    @Override
    public List<JobNode> getSeries() {
        return this.series;
    }

    @Override
    public JobNode getSeriesElement(int index) {
        return this.series.get(index);
    }

    @Override
    boolean isFlow() {
        return true;
    }

    public String toString() {
        return "[Flow:" + this.stringify(true) + "]";
    }
}

