/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.xd.dirt.job.dsl.JobParser;
import org.springframework.xd.dirt.job.dsl.JobReference;
import org.springframework.xd.dirt.job.dsl.JobSpecification;
import org.springframework.xd.dirt.job.dsl.JobSpecificationException;

public class ComposedJobUtil {
    public static final String MODULE_SUFFIX = "_COMPOSED";
    private static String orchestrationPatternString = "(\\|\\|(?=([^\\\"']*[\\\"'][^\\\"']*[\\\"'])*[^\\\"']*$))|(\\&(?=([^\\\"']*[\\\"'][^\\\"']*[\\\"'])*[^\\\"']*$))";
    private static String parameterPatternString = "(--(?=([^\\\"']*[\\\"'][^\\\"']*[\\\"'])*[^\\\"']*$))";
    private static Pattern orchestrationPattern = Pattern.compile(orchestrationPatternString);
    private static Pattern parameterPattern = Pattern.compile(parameterPatternString);

    public static String getComposedJobModuleName(String jobName) {
        return jobName + MODULE_SUFFIX;
    }

    public static boolean isComposedJobDefinition(String definition) {
        boolean result = false;
        try {
            JobParser parser = new JobParser();
            JobSpecification jobSpecification = parser.parse(definition);
            if (jobSpecification.getJobReferences().size() > 1) {
                result = true;
            }
            if (jobSpecification.getJobReferences().size() == 1) {
                JobReference reference = jobSpecification.getJobReferences().get(0);
                if (reference.transitions != null && reference.transitions.size() > 0) {
                    result = true;
                }
            }
        }
        catch (JobSpecificationException e) {
            Matcher matcher = orchestrationPattern.matcher(definition);
            result = matcher.find();
        }
        return result;
    }

    public static void validateNotSingleJobInstance(String definition, Collection<String> jobInstances) {
        String jobName;
        JobSpecification jobSpecification = null;
        try {
            JobParser parser = new JobParser();
            jobSpecification = parser.parse(definition);
        }
        catch (JobSpecificationException e) {
            return;
        }
        if (jobSpecification.getJobReferences().size() == 1 && jobInstances.contains(jobName = jobSpecification.getJobReferences().get(0).getName())) {
            throw new IllegalStateException(String.format("Job Instance specified  %s must use transitions.  Or just launch the job instance directly", jobName));
        }
    }

    public static String getPropertyDefinition() {
        return "options.timeout.description=The timeout for the slave jobs within this orchestration.  -1 indicates no timeout. \noptions.timeout.default=-1\noptions.timeout.type=long";
    }

    public static String getDefinitionParameters(String definition) {
        Matcher matcher = parameterPattern.matcher(definition);
        String result = "";
        if (matcher.find()) {
            result = " " + definition.substring(matcher.start());
        }
        return result;
    }
}

