/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import java.util.List;
import org.springframework.xd.dirt.job.dsl.JobDSLMessage;
import org.springframework.xd.dirt.job.dsl.JobSpecificationException;
import org.springframework.xd.dirt.job.dsl.Token;

public class CheckpointedJobDefinitionException
extends JobSpecificationException {
    private int checkpointPointer = -1;
    private List<Token> tokens;
    private int tokenPointer;

    public CheckpointedJobDefinitionException(String expressionString, int textPosition, int tokenPointer, int checkpointPointer, List<Token> tokens, JobDSLMessage message, Object ... inserts) {
        super(expressionString, textPosition, message, inserts);
        this.tokenPointer = tokenPointer;
        this.checkpointPointer = checkpointPointer;
        this.tokens = tokens;
    }

    @Override
    public String getMessage() {
        StringBuilder s = new StringBuilder();
        if (this.message != null) {
            s.append(this.message.formatMessage(this.position, this.inserts));
        } else {
            s.append(super.getMessage());
        }
        if (this.expressionString != null && this.expressionString.length() > 0) {
            s.append("\n").append(this.expressionString).append("\n");
        }
        int offset = this.position;
        if (this.checkpointPointer > 0 && offset >= 0) {
            int checkpointPosition = this.getCheckpointPosition();
            offset -= checkpointPosition;
            for (int i = 0; i < checkpointPosition; ++i) {
                s.append(' ');
            }
            s.append("*");
            --offset;
        }
        if (offset >= 0) {
            for (int i = 0; i < offset; ++i) {
                s.append(' ');
            }
            s.append("^\n");
        }
        return s.toString();
    }

    public int getCheckpointPosition() {
        return this.checkpointPointer == 0 ? 0 : this.tokens.get((int)(this.checkpointPointer - 1)).endpos;
    }

    public String getExpressionStringUntilCheckpoint() {
        return this.expressionString.substring(0, this.getCheckpointPosition());
    }

    public int getCheckpointPointer() {
        return this.checkpointPointer;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public int getTokenPointer() {
        return this.tokenPointer;
    }
}

