/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dao;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.admin.service.JdbcSearchableJobExecutionDao;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.item.database.Order;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

public class XdJdbcSearchableJobExecutionDao
extends JdbcSearchableJobExecutionDao {
    private static final String FIELDS = "E.JOB_EXECUTION_ID, E.START_TIME, E.END_TIME, E.STATUS, E.EXIT_CODE, E.EXIT_MESSAGE, E.CREATE_TIME, E.LAST_UPDATED, E.VERSION, I.JOB_INSTANCE_ID, I.JOB_NAME";
    private PagingQueryProvider allExecutionsPagingQueryProvider;
    private PagingQueryProvider childJobExecutionsPagingQueryProvider;
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        super.setDataSource(dataSource);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"DataSource must be provided");
        if (this.getJdbcTemplate() == null) {
            this.setJdbcTemplate((JdbcOperations)new JdbcTemplate(this.dataSource));
        }
        this.setJobExecutionIncrementer((DataFieldMaxValueIncrementer)new AbstractDataFieldMaxValueIncrementer(){

            protected long getNextKey() {
                return 0L;
            }
        });
        String subQuery = this.getQuery("not exists (select * from %PREFIX%JOB_EXECUTION_PARAMS a where key_name = 'xd_parent_execution_id' and E.JOB_EXECUTION_ID=a.JOB_EXECUTION_ID)");
        this.allExecutionsPagingQueryProvider = this.getPagingQueryProvider(subQuery);
        String childJobExecutionsSubQuery = this.getQuery("exists (select * from %PREFIX%JOB_EXECUTION_PARAMS a where key_name = 'xd_parent_execution_id' and E.JOB_EXECUTION_ID=a.JOB_EXECUTION_ID and string_val=?)");
        this.childJobExecutionsPagingQueryProvider = this.getPagingQueryProvider(childJobExecutionsSubQuery);
        super.afterPropertiesSet();
    }

    private PagingQueryProvider getPagingQueryProvider(String whereClause) throws Exception {
        SqlPagingQueryProviderFactoryBean factory = new SqlPagingQueryProviderFactoryBean();
        factory.setDataSource(this.dataSource);
        String fromClause = "%PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I";
        factory.setFromClause(this.getQuery(fromClause));
        factory.setSelectClause(FIELDS);
        HashMap<String, Order> sortKeys = new HashMap<String, Order>();
        sortKeys.put("JOB_EXECUTION_ID", Order.DESCENDING);
        factory.setSortKeys(sortKeys);
        whereClause = "E.JOB_INSTANCE_ID=I.JOB_INSTANCE_ID" + (whereClause == null ? "" : " and " + whereClause);
        factory.setWhereClause(whereClause);
        return factory.getObject();
    }

    public List<JobExecution> getTopLevelJobExecutions(int start, int count) {
        if (start <= 0) {
            return this.getJdbcTemplate().query(this.allExecutionsPagingQueryProvider.generateFirstPageQuery(count), (RowMapper)new JdbcSearchableJobExecutionDao.JobExecutionRowMapper((JdbcSearchableJobExecutionDao)this));
        }
        try {
            Long startAfterValue = (Long)this.getJdbcTemplate().queryForObject(this.allExecutionsPagingQueryProvider.generateJumpToItemQuery(start, count), Long.class);
            return this.getJdbcTemplate().query(this.allExecutionsPagingQueryProvider.generateRemainingPagesQuery(count), (RowMapper)new JdbcSearchableJobExecutionDao.JobExecutionRowMapper((JdbcSearchableJobExecutionDao)this), new Object[]{startAfterValue});
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return Collections.emptyList();
        }
    }

    public int countTopLevelJobExecutions() {
        return (Integer)this.getJdbcTemplate().queryForObject(this.getQuery("SELECT COUNT(1) from %PREFIX%JOB_EXECUTION bje where not exists (select 1 from %PREFIX%JOB_EXECUTION_PARAMS bje_params where key_name = 'xd_parent_execution_id' and bje.JOB_EXECUTION_ID=bje_params.JOB_EXECUTION_ID)"), Integer.class);
    }

    public List<JobExecution> getChildJobExecutions(long jobExecutionId) {
        try {
            return this.getJdbcTemplate().query(this.childJobExecutionsPagingQueryProvider.generateFirstPageQuery(100000), (RowMapper)new JdbcSearchableJobExecutionDao.JobExecutionRowMapper((JdbcSearchableJobExecutionDao)this), new Object[]{String.valueOf(jobExecutionId)});
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isComposedJobExecution(long jobExecutionId) {
        String query = this.getQuery("select count(*) from %PREFIX%JOB_EXECUTION_PARAMS a where key_name = 'xd_parent_execution_id' and string_val = ?");
        int count = (Integer)this.getJdbcTemplate().queryForObject(query, Integer.class, new Object[]{String.valueOf(jobExecutionId)});
        return count > 0;
    }
}

