/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job;

import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.xd.dirt.job.StepType;
import org.springframework.xd.dirt.job.TaskletType;
import org.springframework.xd.rest.domain.util.TimeUtils;

public class StepExecutionInfo {
    private DateFormat dateFormat = TimeUtils.getDefaultDateFormat();
    private DateFormat timeFormat = TimeUtils.getDefaultTimeFormat();
    private DateFormat durationFormat = TimeUtils.getDefaultDurationFormat();
    private Long id;
    private Long jobExecutionId;
    private String jobName;
    private String name;
    private String startDate = "-";
    private String startTime = "-";
    private String duration = "-";
    private StepExecution stepExecution;
    private long durationMillis;
    private String stepType = StepType.UNKNOWN.getDisplayName();

    public StepExecutionInfo(String jobName, Long jobExecutionId, String name, TimeZone timeZone) {
        this.jobName = jobName;
        this.jobExecutionId = jobExecutionId;
        this.name = name;
        this.stepExecution = new StepExecution(name, new JobExecution(jobExecutionId));
    }

    public StepExecutionInfo(StepExecution stepExecution, TimeZone timeZone) {
        this.stepExecution = stepExecution;
        this.id = stepExecution.getId();
        this.name = stepExecution.getStepName();
        this.jobName = stepExecution.getJobExecution() == null || stepExecution.getJobExecution().getJobInstance() == null ? "?" : stepExecution.getJobExecution().getJobInstance().getJobName();
        this.jobExecutionId = stepExecution.getJobExecutionId();
        this.durationFormat.setTimeZone(TimeUtils.getDefaultTimeZone());
        this.timeFormat.setTimeZone(timeZone);
        this.dateFormat.setTimeZone(timeZone);
        if (stepExecution.getStartTime() != null) {
            this.startDate = this.dateFormat.format(stepExecution.getStartTime());
            this.startTime = this.timeFormat.format(stepExecution.getStartTime());
            Date endTime = stepExecution.getEndTime() != null ? stepExecution.getEndTime() : new Date();
            this.durationMillis = endTime.getTime() - stepExecution.getStartTime().getTime();
            this.duration = this.durationFormat.format(new Date(this.durationMillis));
        }
        if (stepExecution.getExecutionContext().containsKey("batch.taskletType")) {
            String taskletClassName = stepExecution.getExecutionContext().getString("batch.taskletType");
            TaskletType type = TaskletType.fromClassName(taskletClassName);
            this.stepType = type == TaskletType.UNKNOWN ? taskletClassName : type.getDisplayName();
        } else if (stepExecution.getExecutionContext().containsKey("batch.stepType")) {
            String stepClassName = stepExecution.getExecutionContext().getString("batch.stepType");
            StepType type = StepType.fromClassName(stepClassName);
            this.stepType = type == StepType.UNKNOWN ? stepClassName : type.getDisplayName();
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getJobExecutionId() {
        return this.jobExecutionId;
    }

    public String getName() {
        return this.name;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public String getStatus() {
        if (this.id != null) {
            return this.stepExecution.getStatus().toString();
        }
        return "NONE";
    }

    public String getExitCode() {
        if (this.id != null) {
            return this.stepExecution.getExitStatus().getExitCode();
        }
        return "NONE";
    }

    public StepExecution getStepExecution() {
        return this.stepExecution;
    }

    public String getStepType() {
        return this.stepType;
    }
}

