/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job;

import java.util.List;
import java.util.Map;
import org.springframework.data.repository.CrudRepository;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.BaseDefinition;
import org.springframework.xd.dirt.core.Job;
import org.springframework.xd.dirt.job.dsl.ComposedJobUtil;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.stream.JobDefinitionRepository;
import org.springframework.xd.dirt.stream.ParsingContext;
import org.springframework.xd.dirt.stream.XDStreamParser;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.rest.domain.support.DeploymentPropertiesFormat;

public class JobFactory {
    private final XDStreamParser parser;

    public JobFactory(JobDefinitionRepository jobDefinitionRepository, ModuleRegistry moduleRegistry, ModuleOptionsMetadataResolver moduleOptionsMetadataResolver) {
        this.parser = new XDStreamParser((CrudRepository<? extends BaseDefinition, String>)jobDefinitionRepository, moduleRegistry, moduleOptionsMetadataResolver);
    }

    public Job createJob(String name, Map<String, String> properties) {
        List<ModuleDescriptor> descriptors;
        Assert.hasText((String)name, (String)"Job name is required");
        Assert.notNull(properties, (String)"Job properties are required");
        String definition = properties.get("definition");
        Assert.hasText((String)definition, (String)"Job properties requires a 'definition' property");
        if (ComposedJobUtil.isComposedJobDefinition(definition)) {
            definition = ComposedJobUtil.getComposedJobModuleName(name) + ComposedJobUtil.getDefinitionParameters(definition);
        }
        Assert.isTrue(((descriptors = this.parser.parse(name, definition, ParsingContext.job)).size() == 1 ? 1 : 0) != 0);
        return new Job.Builder().setName(name).setDeploymentProperties(DeploymentPropertiesFormat.parseDeploymentProperties((String)properties.get("deploymentProperties"))).setModuleDescriptor(descriptors.get(0)).build();
    }
}

