/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job;

import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.springframework.batch.admin.web.JobParametersExtractor;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.xd.rest.domain.util.TimeUtils;

public class JobExecutionInfo {
    private DateFormat dateFormat = TimeUtils.getDefaultDateFormat();
    private DateFormat timeFormat = TimeUtils.getDefaultTimeFormat();
    private DateFormat durationFormat = TimeUtils.getDefaultDurationFormat();
    private Long executionId;
    private int stepExecutionCount;
    private Long jobId;
    private String jobName;
    private String startDate = "";
    private String startTime = "";
    private String duration = "";
    private JobExecution jobExecution;
    private Properties jobParameters;
    private String jobParametersString;
    private boolean restartable = false;
    private boolean abandonable = false;
    private boolean stoppable = false;
    private JobParametersConverter converter = new DefaultJobParametersConverter();
    private final TimeZone timeZone;

    public JobExecutionInfo(JobExecution jobExecution, TimeZone timeZone) {
        this.jobExecution = jobExecution;
        this.timeZone = timeZone;
        this.executionId = jobExecution.getId();
        this.jobId = jobExecution.getJobId();
        this.stepExecutionCount = jobExecution.getStepExecutions().size();
        this.jobParameters = this.converter.getProperties(jobExecution.getJobParameters());
        this.jobParametersString = new JobParametersExtractor().fromJobParameters(jobExecution.getJobParameters());
        JobInstance jobInstance = jobExecution.getJobInstance();
        if (jobInstance != null) {
            this.jobName = jobInstance.getJobName();
            BatchStatus status = jobExecution.getStatus();
            this.restartable = status.isGreaterThan(BatchStatus.STOPPING) && status.isLessThan(BatchStatus.ABANDONED);
            this.abandonable = status.isGreaterThan(BatchStatus.STARTED) && status != BatchStatus.ABANDONED;
            this.stoppable = status.isLessThan(BatchStatus.STOPPING);
        } else {
            this.jobName = "?";
        }
        this.durationFormat.setTimeZone(TimeUtils.getDefaultTimeZone());
        this.timeFormat.setTimeZone(timeZone);
        this.dateFormat.setTimeZone(timeZone);
        if (jobExecution.getStartTime() != null) {
            this.startDate = this.dateFormat.format(jobExecution.getStartTime());
            this.startTime = this.timeFormat.format(jobExecution.getStartTime());
            Date endTime = jobExecution.getEndTime() != null ? jobExecution.getEndTime() : new Date();
            this.duration = this.durationFormat.format(new Date(endTime.getTime() - jobExecution.getStartTime().getTime()));
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getName() {
        return this.jobName;
    }

    public Long getExecutionId() {
        return this.executionId;
    }

    public int getStepExecutionCount() {
        return this.stepExecutionCount;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isAbandonable() {
        return this.abandonable;
    }

    public boolean isStoppable() {
        return this.stoppable;
    }

    public String getJobParametersString() {
        return this.jobParametersString;
    }

    public Properties getJobParameters() {
        return this.jobParameters;
    }
}

