/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job;

import org.springframework.batch.core.ExitStatus;
import org.springframework.xd.dirt.job.JobExecutionInfo;
import org.springframework.xd.dirt.job.JobInfo;

public class DetailedJobInfo
extends JobInfo {
    private String jobParameters;
    private String duration;
    private String startTime;
    private String startDate;
    private int stepExecutionCount;
    private ExitStatus exitStatus;
    private JobExecutionInfo lastExecutionInfo;

    public DetailedJobInfo(String name, int executionCount, boolean launchable, boolean incrementable, JobExecutionInfo lastExecution, boolean deployed) {
        super(name, executionCount, launchable, incrementable, deployed);
        this.lastExecutionInfo = lastExecution;
        if (this.lastExecutionInfo != null) {
            this.jobParameters = lastExecution.getJobParametersString();
            this.duration = lastExecution.getDuration();
            this.startTime = lastExecution.getStartTime();
            this.startDate = lastExecution.getStartDate();
            this.stepExecutionCount = lastExecution.getStepExecutionCount();
            this.exitStatus = lastExecution.getJobExecution().getExitStatus();
        }
    }

    public JobExecutionInfo getLastExecutionInfo() {
        return this.lastExecutionInfo;
    }

    public String getJobParameters() {
        return this.jobParameters;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public int getStepExecutionCount() {
        return this.stepExecutionCount;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }
}

