/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.jdbc.util;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.support.JdbcUtils;

public class DatabaseVendorFriendlyNameFactoryBean
implements FactoryBean<String>,
InitializingBean {
    private String friendlyName;
    private DataSource dataSource;
    private Map<String, String> vendorToFriendlyNames = new HashMap<String, String>();
    private String override;

    public DatabaseVendorFriendlyNameFactoryBean() {
        this.vendorToFriendlyNames.put("DB2", "db2");
        this.vendorToFriendlyNames.put("Apache Derby", "derby");
        this.vendorToFriendlyNames.put("H2", "h2");
        this.vendorToFriendlyNames.put("HSQL Database Engine", "hsqldb");
        this.vendorToFriendlyNames.put("MySQL", "mysql");
        this.vendorToFriendlyNames.put("Oracle", "oracle10g");
        this.vendorToFriendlyNames.put("PostgreSQL", "postgresql");
        this.vendorToFriendlyNames.put("Microsoft SQL Server", "sqlserver");
        this.vendorToFriendlyNames.put("Sybase", "sybase");
    }

    public String getObject() throws Exception {
        return this.friendlyName;
    }

    public Class<?> getObjectType() {
        return String.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.override != null) {
            this.friendlyName = this.override;
            return;
        }
        String vendorName = JdbcUtils.commonDatabaseName((String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getDatabaseProductName").toString());
        if (!this.vendorToFriendlyNames.containsKey(vendorName)) {
            throw new BeanInitializationException(String.format("Detected database vendor name %s but no mapping found for it in %s", vendorName, this.vendorToFriendlyNames));
        }
        this.friendlyName = this.vendorToFriendlyNames.get(vendorName);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setOverride(String override) {
        this.override = override;
    }

    public void setMappings(Map<String, String> mappings) {
        this.vendorToFriendlyNames = mappings;
    }
}

