/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus.rabbit;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.xd.dirt.integration.bus.BusCleaner;
import org.springframework.xd.dirt.integration.bus.BusUtils;
import org.springframework.xd.dirt.integration.bus.MessageBusSupport;
import org.springframework.xd.dirt.integration.bus.RabbitAdminException;
import org.springframework.xd.dirt.integration.bus.RabbitManagementUtils;
import org.springframework.xd.dirt.plugins.AbstractJobPlugin;
import org.springframework.xd.dirt.plugins.job.JobEventsListenerPlugin;

public class RabbitBusCleaner
implements BusCleaner {
    private static final Logger logger = LoggerFactory.getLogger(RabbitBusCleaner.class);

    @Override
    public Map<String, List<String>> clean(String entity, boolean isJob) {
        return this.clean("http://localhost:15672", "guest", "guest", "/", "xdbus.", entity, isJob);
    }

    public Map<String, List<String>> clean(String adminUri, String user, String pw, String vhost, String busPrefix, String entity, boolean isJob) {
        return this.doClean(adminUri == null ? "http://localhost:15672" : adminUri, user == null ? "guest" : user, pw == null ? "guest" : pw, vhost == null ? "/" : vhost, busPrefix == null ? "xdbus." : busPrefix, entity, isJob);
    }

    private Map<String, List<String>> doClean(String adminUri, String user, String pw, String vhost, String busPrefix, String entity, boolean isJob) {
        ExchangeCandidateCallback callback;
        List<String> removedQueues;
        RestTemplate restTemplate = RabbitManagementUtils.buildRestTemplate((String)adminUri, (String)user, (String)pw);
        List<String> list = removedQueues = isJob ? this.findJobQueues(adminUri, vhost, busPrefix, entity, restTemplate) : this.findStreamQueues(adminUri, vhost, busPrefix, entity, restTemplate);
        if (isJob) {
            String pattern = entity.endsWith("*") ? entity.substring(0, entity.length() - 1) + "[^.]*" : entity;
            Collection<String> exchangeNames = JobEventsListenerPlugin.getEventListenerChannels(pattern).values();
            final HashSet<Pattern> jobExchanges = new HashSet<Pattern>();
            for (String exchange : exchangeNames) {
                jobExchanges.add(Pattern.compile(MessageBusSupport.applyPrefix((String)busPrefix, (String)MessageBusSupport.applyPubSub((String)exchange))));
            }
            jobExchanges.add(Pattern.compile(MessageBusSupport.applyPrefix((String)busPrefix, (String)MessageBusSupport.applyPubSub((String)JobEventsListenerPlugin.getEventListenerChannelName(pattern)))));
            callback = new ExchangeCandidateCallback(){

                @Override
                public boolean isCandidate(String exchangeName) {
                    for (Pattern pattern : jobExchanges) {
                        Matcher matcher = pattern.matcher(exchangeName);
                        if (!matcher.matches()) continue;
                        return true;
                    }
                    return false;
                }
            };
        } else {
            final String tapPrefix = this.adjustPrefix(MessageBusSupport.applyPrefix((String)busPrefix, (String)MessageBusSupport.applyPubSub((String)BusUtils.constructTapPrefix((String)entity))));
            callback = new ExchangeCandidateCallback(){

                @Override
                public boolean isCandidate(String exchangeName) {
                    return exchangeName.startsWith(tapPrefix);
                }
            };
        }
        List<String> removedExchanges = this.findExchanges(adminUri, vhost, busPrefix, entity, restTemplate, callback);
        for (int i = removedQueues.size() - 1; i >= 0; --i) {
            String queueName = removedQueues.get(i);
            URI uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"queues", "{vhost}", "{stream}"}).buildAndExpand(new Object[]{vhost, queueName}).encode().toUri();
            restTemplate.delete(uri);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("deleted queue: " + queueName);
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        if (removedQueues.size() > 0) {
            results.put("queues", removedQueues);
        }
        for (String exchange : removedExchanges) {
            URI uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"exchanges", "{vhost}", "{name}"}).buildAndExpand(new Object[]{vhost, exchange}).encode().toUri();
            restTemplate.delete(uri);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("deleted exchange: " + exchange);
        }
        if (removedExchanges.size() > 0) {
            results.put("exchanges", removedExchanges);
        }
        return results;
    }

    private List<String> findStreamQueues(String adminUri, String vhost, String busPrefix, String stream, RestTemplate restTemplate) {
        String queueNamePrefix = this.adjustPrefix(MessageBusSupport.applyPrefix((String)busPrefix, (String)stream));
        List<Map<String, Object>> queues = this.listAllQueues(adminUri, vhost, restTemplate);
        ArrayList<String> removedQueues = new ArrayList<String>();
        for (Map<String, Object> queue : queues) {
            String queueName = (String)queue.get("name");
            if (!queueName.startsWith(queueNamePrefix)) continue;
            this.checkNoConsumers(queueName, queue);
            removedQueues.add(queueName);
        }
        return removedQueues;
    }

    private List<String> findJobQueues(String adminUri, String vhost, String busPrefix, String job, RestTemplate restTemplate) {
        ArrayList<String> removedQueues = new ArrayList<String>();
        String jobQueueName = MessageBusSupport.applyPrefix((String)busPrefix, (String)AbstractJobPlugin.getJobChannelName(job));
        String jobRequestsQueuePrefix = this.adjustPrefix(MessageBusSupport.applyPrefix((String)busPrefix, (String)AbstractJobPlugin.getJobChannelName(job)));
        List<Map<String, Object>> queues = this.listAllQueues(adminUri, vhost, restTemplate);
        for (Map<String, Object> queue : queues) {
            String queueName = (String)queue.get("name");
            if (job.endsWith("*")) {
                if (!queueName.startsWith(jobQueueName.substring(0, jobQueueName.length() - 1))) continue;
                this.checkNoConsumers(queueName, queue);
                removedQueues.add(queueName);
                continue;
            }
            if (queueName.equals(jobQueueName)) {
                this.checkNoConsumers(queueName, queue);
                removedQueues.add(queueName);
                continue;
            }
            if (!queueName.startsWith(jobRequestsQueuePrefix) || !queueName.endsWith(MessageBusSupport.applyRequests((String)""))) continue;
            this.checkNoConsumers(queueName, queue);
            removedQueues.add(queueName);
        }
        return removedQueues;
    }

    private List<Map<String, Object>> listAllQueues(String adminUri, String vhost, RestTemplate restTemplate) {
        URI uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"queues", "{vhost}"}).buildAndExpand(new Object[]{vhost}).encode().toUri();
        List queues = (List)restTemplate.getForObject(uri, List.class);
        return queues;
    }

    private String adjustPrefix(String prefix) {
        if (prefix.endsWith("*")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix + ".";
    }

    private void checkNoConsumers(String queueName, Map<String, Object> queue) {
        if (!queue.get("consumers").equals(0)) {
            throw new RabbitAdminException("Queue " + queueName + " is in use");
        }
    }

    private List<String> findExchanges(String adminUri, String vhost, String busPrefix, String entity, RestTemplate restTemplate, ExchangeCandidateCallback callback) {
        ArrayList<String> removedExchanges = new ArrayList<String>();
        URI uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"exchanges", "{vhost}"}).buildAndExpand(new Object[]{vhost}).encode().toUri();
        List exchanges = (List)restTemplate.getForObject(uri, List.class);
        for (Map exchange : exchanges) {
            String exchangeName = (String)exchange.get("name");
            if (!callback.isCandidate(exchangeName)) continue;
            uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"exchanges", "{vhost}", "{name}", "bindings", "source"}).buildAndExpand(new Object[]{vhost, exchangeName}).encode().toUri();
            List bindings = (List)restTemplate.getForObject(uri, List.class);
            if (bindings.size() == 0) {
                uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"exchanges", "{vhost}", "{name}", "bindings", "destination"}).buildAndExpand(new Object[]{vhost, exchangeName}).encode().toUri();
                bindings = (List)restTemplate.getForObject(uri, List.class);
                if (bindings.size() == 0) {
                    removedExchanges.add((String)exchange.get("name"));
                    continue;
                }
                throw new RabbitAdminException("Cannot delete exchange " + exchangeName + "; it is a destination: " + bindings);
            }
            throw new RabbitAdminException("Cannot delete exchange " + exchangeName + "; it has bindings: " + bindings);
        }
        return removedExchanges;
    }

    private static interface ExchangeCandidateCallback {
        public boolean isCandidate(String var1);
    }
}

