/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus.converter;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.xd.dirt.integration.bus.StringConvertingContentTypeResolver;
import org.springframework.xd.dirt.integration.bus.converter.AbstractFromMessageConverter;

public class StringToByteArrayMessageConverter
extends AbstractFromMessageConverter {
    private static final ContentTypeResolver contentTypeResolver = new StringConvertingContentTypeResolver();
    private static final List<MimeType> targetMimeTypes = new ArrayList<MimeType>();

    public StringToByteArrayMessageConverter() {
        super(targetMimeTypes);
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{byte[].class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{String.class};
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        MimeType mimeType = contentTypeResolver.resolve(message.getHeaders());
        byte[] converted = null;
        if (mimeType == null || mimeType.getParameter("Charset") == null) {
            converted = ((String)message.getPayload()).getBytes();
        } else {
            String encoding = mimeType.getParameter("Charset");
            if (encoding != null) {
                try {
                    converted = ((String)message.getPayload()).getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return converted;
    }

    static {
        targetMimeTypes.add(MimeTypeUtils.APPLICATION_OCTET_STREAM);
    }
}

