/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus.converter;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.springframework.messaging.Message;
import org.springframework.xd.dirt.integration.bus.converter.AbstractFromMessageConverter;
import org.springframework.xd.dirt.integration.bus.converter.MessageConverterUtils;

public class SerializedToJavaMessageConverter
extends AbstractFromMessageConverter {
    public SerializedToJavaMessageConverter() {
        super(MessageConverterUtils.X_JAVA_SERIALIZED_OBJECT, MessageConverterUtils.X_JAVA_OBJECT);
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{Serializable.class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{byte[].class};
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        ByteArrayInputStream bis = new ByteArrayInputStream((byte[])message.getPayload());
        Object result = null;
        try {
            result = new ObjectInputStream(bis).readObject();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return this.buildConvertedMessage(result, message.getHeaders(), MessageConverterUtils.javaObjectMimeType(targetClass));
    }
}

