/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus.converter;

import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.xd.dirt.integration.bus.converter.ConversionException;
import org.springframework.xd.tuple.DefaultTuple;

public class MessageConverterUtils {
    public static final MimeType X_XD_TUPLE = MimeType.valueOf((String)"application/x-xd-tuple");
    public static final MimeType X_XD_STRING = MimeType.valueOf((String)"application/x-xd-string");
    public static final MimeType X_JAVA_OBJECT = MimeType.valueOf((String)"application/x-java-object");
    public static final MimeType X_JAVA_SERIALIZED_OBJECT = MimeType.valueOf((String)"application/x-java-serialized-object");

    public static Class<?> getJavaTypeForContentType(MimeType contentType, ClassLoader classLoader) {
        if (X_JAVA_OBJECT.includes(contentType)) {
            if (contentType.getParameter("type") != null) {
                try {
                    return ClassUtils.forName((String)contentType.getParameter("type"), (ClassLoader)classLoader);
                }
                catch (Exception e) {
                    throw new ConversionException(e.getMessage(), e);
                }
            }
            return Object.class;
        }
        if (MimeTypeUtils.APPLICATION_JSON.equals((Object)contentType)) {
            return String.class;
        }
        if (MimeType.valueOf((String)"text/*").includes(contentType)) {
            return String.class;
        }
        if (X_XD_TUPLE.includes(contentType)) {
            return DefaultTuple.class;
        }
        if (MimeTypeUtils.APPLICATION_OCTET_STREAM.includes(contentType)) {
            return byte[].class;
        }
        if (X_JAVA_SERIALIZED_OBJECT.includes(contentType)) {
            return byte[].class;
        }
        if (X_XD_STRING.includes(contentType)) {
            return String.class;
        }
        return null;
    }

    public static MimeType javaObjectMimeType(Class<?> clazz) {
        return MimeType.valueOf((String)("application/x-java-object;type=" + clazz.getName()));
    }
}

