/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus.converter;

import java.util.ArrayList;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.xd.dirt.integration.bus.converter.AbstractFromMessageConverter;
import org.springframework.xd.dirt.integration.bus.converter.MessageConverterUtils;
import org.springframework.xd.tuple.Tuple;
import org.springframework.xd.tuple.TupleBuilder;

public class JsonToTupleMessageConverter
extends AbstractFromMessageConverter {
    private static final List<MimeType> targetMimeTypes = new ArrayList<MimeType>();

    public JsonToTupleMessageConverter() {
        super(MimeTypeUtils.APPLICATION_JSON, targetMimeTypes);
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{Tuple.class};
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{byte[].class, String.class};
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        String source = null;
        source = message.getPayload() instanceof byte[] ? new String((byte[])message.getPayload()) : (String)message.getPayload();
        Tuple t = TupleBuilder.fromString((String)source);
        return this.buildConvertedMessage(t, message.getHeaders(), MessageConverterUtils.javaObjectMimeType(t.getClass()));
    }

    static {
        targetMimeTypes.add(MessageConverterUtils.X_XD_TUPLE);
        targetMimeTypes.add(MessageConverterUtils.X_JAVA_OBJECT);
    }
}

