/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.messaging.Message;
import org.springframework.util.MimeTypeUtils;
import org.springframework.xd.dirt.integration.bus.converter.AbstractFromMessageConverter;
import org.springframework.xd.dirt.integration.bus.converter.MessageConverterUtils;

public class JsonToPojoMessageConverter
extends AbstractFromMessageConverter {
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonToPojoMessageConverter() {
        super(MimeTypeUtils.APPLICATION_JSON, MessageConverterUtils.X_JAVA_OBJECT);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    @Override
    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{String.class, byte[].class};
    }

    @Override
    protected Class<?>[] supportedTargetTypes() {
        return null;
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object result = null;
        try {
            Object payload = message.getPayload();
            if (payload instanceof byte[]) {
                result = this.mapper.readValue((byte[])payload, targetClass);
            } else if (payload instanceof String) {
                result = this.mapper.readValue((String)payload, targetClass);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return this.buildConvertedMessage(result, message.getHeaders(), MessageConverterUtils.javaObjectMimeType(targetClass));
    }
}

