/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.xd.dirt.integration.bus.converter.AbstractFromMessageConverter;
import org.springframework.xd.dirt.integration.bus.converter.ConversionException;

public class CompositeMessageConverterFactory {
    private final List<AbstractFromMessageConverter> converters;

    public CompositeMessageConverterFactory(Collection<AbstractFromMessageConverter> converters) {
        Assert.notNull(converters, (String)"'converters' cannot be null");
        this.converters = new ArrayList<AbstractFromMessageConverter>(converters);
    }

    public CompositeMessageConverter newInstance(MimeType targetMimeType) {
        ArrayList<AbstractFromMessageConverter> targetMimeTypeConverters = new ArrayList<AbstractFromMessageConverter>();
        for (AbstractFromMessageConverter converter : this.converters) {
            if (!converter.supportsTargetMimeType(targetMimeType)) continue;
            targetMimeTypeConverters.add(converter);
        }
        if (CollectionUtils.isEmpty(targetMimeTypeConverters)) {
            throw new ConversionException("No message converter is registered for " + targetMimeType.toString());
        }
        return new CompositeMessageConverter(targetMimeTypeConverters);
    }
}

