/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.xd.dirt.integration.bus.StrictContentTypeResolver;
import org.springframework.xd.dirt.integration.bus.StringConvertingContentTypeResolver;

public abstract class AbstractFromMessageConverter
extends AbstractMessageConverter {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final List<MimeType> targetMimeTypes;

    protected AbstractFromMessageConverter(MimeType targetMimeType) {
        this(new ArrayList<MimeType>(), targetMimeType, (ContentTypeResolver)new StrictContentTypeResolver(targetMimeType));
    }

    protected AbstractFromMessageConverter(Collection<MimeType> targetMimeTypes) {
        this(new ArrayList<MimeType>(), targetMimeTypes, (ContentTypeResolver)new StringConvertingContentTypeResolver());
    }

    protected AbstractFromMessageConverter(Collection<MimeType> supportedSourceMimeTypes, MimeType targetMimeType, ContentTypeResolver contentTypeResolver) {
        super(supportedSourceMimeTypes);
        Assert.notNull((Object)targetMimeType, (String)"'targetMimeType' cannot be null");
        this.setContentTypeResolver(contentTypeResolver);
        this.targetMimeTypes = Collections.singletonList(targetMimeType);
    }

    protected AbstractFromMessageConverter(Collection<MimeType> supportedSourceMimeTypes, Collection<MimeType> targetMimeTypes, ContentTypeResolver contentTypeResolver) {
        super(supportedSourceMimeTypes);
        Assert.notNull(targetMimeTypes, (String)"'targetMimeTypes' cannot be null");
        this.setContentTypeResolver(contentTypeResolver);
        this.targetMimeTypes = new ArrayList<MimeType>(targetMimeTypes);
    }

    protected AbstractFromMessageConverter(MimeType supportedSourceMimeType, MimeType targetMimeType) {
        this(Collections.singletonList(supportedSourceMimeType), targetMimeType, (ContentTypeResolver)new StrictContentTypeResolver(supportedSourceMimeType));
    }

    protected AbstractFromMessageConverter(MimeType supportedSourceMimeType, Collection<MimeType> targetMimeTypes) {
        this(Collections.singletonList(supportedSourceMimeType), targetMimeTypes, (ContentTypeResolver)new StrictContentTypeResolver(supportedSourceMimeType));
    }

    protected abstract Class<?>[] supportedTargetTypes();

    protected abstract Class<?>[] supportedPayloadTypes();

    protected boolean supportsPayloadType(Class<?> clazz) {
        return this.supportsType(clazz, this.supportedPayloadTypes());
    }

    protected boolean supports(Class<?> clazz) {
        return this.supportsType(clazz, this.supportedTargetTypes());
    }

    private boolean supportsType(Class<?> clazz, Class<?>[] supportedTypes) {
        if (supportedTypes != null) {
            for (Class<?> targetType : supportedTypes) {
                if (!ClassUtils.isAssignable(clazz, targetType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return super.canConvertFrom(message, targetClass) && this.supportsPayloadType(message.getPayload().getClass());
    }

    public boolean supportsTargetMimeType(MimeType mimeType) {
        for (MimeType targetMimeType : this.targetMimeTypes) {
            if (!mimeType.getType().equals(targetMimeType.getType()) || !mimeType.getSubtype().equals(targetMimeType.getSubtype())) continue;
            return true;
        }
        return false;
    }

    public void setContentTypeResolver(ContentTypeResolver resolver) {
        if (this.getContentTypeResolver() == null) {
            super.setContentTypeResolver(resolver);
        }
    }

    protected boolean canConvertTo(Object payload, MessageHeaders headers) {
        return false;
    }

    protected final Message<?> buildConvertedMessage(Object payload, MessageHeaders headers, MimeType contentType) {
        return MessageBuilder.withPayload((Object)payload).copyHeaders((Map)headers).copyHeaders(Collections.singletonMap("contentType", contentType)).build();
    }
}

