/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus;

import java.util.Properties;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.BeanFactoryMessageChannelDestinationResolver;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.xd.dirt.integration.bus.MessageBus;

public class MessageBusAwareChannelResolver
extends BeanFactoryMessageChannelDestinationResolver {
    private final MessageBus messageBus;
    private final Properties producerProperties;

    public MessageBusAwareChannelResolver(MessageBus messageBus, Properties producerProperties) {
        this.messageBus = messageBus;
        this.producerProperties = producerProperties;
    }

    public MessageChannel resolveDestination(String name) {
        MessageChannel channel = null;
        try {
            return super.resolveDestination(name);
        }
        catch (DestinationResolutionException e) {
            if (name.indexOf(":") != -1 && this.messageBus != null) {
                String[] tokens = name.split(":", 2);
                String type = tokens[0];
                if ("queue".equals(type)) {
                    channel = this.messageBus.bindDynamicProducer(name, this.producerProperties);
                } else if ("topic".equals(type)) {
                    channel = this.messageBus.bindDynamicPubSubProducer(name, this.producerProperties);
                } else {
                    throw new IllegalArgumentException("unrecognized channel type: " + type);
                }
            }
            if (channel == null) {
                channel = super.resolveDestination(name);
            }
            return channel;
        }
    }
}

