/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractEvent<S>
extends ApplicationEvent {
    private final Map<String, String> attributes = new HashMap<String, String>();

    public AbstractEvent(S source) {
        super(source);
    }

    public S getSource() {
        return (S)super.getSource();
    }

    public final String getType() {
        String name = ((Object)((Object)this)).getClass().getSimpleName();
        return name.replace("Event", "");
    }

    public final Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"timestamp\":" + this.getTimestamp() + ",");
        sb.append("\"type\":\"" + this.getType() + "\"");
        sb.append("}");
        return sb.toString();
    }
}

