/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.core;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.zookeeper.Paths;

public class StreamDeploymentsPath {
    private static final int DEPLOYMENTS = 0;
    private static final int STREAMS = 1;
    private static final int STREAM_NAME = 2;
    private static final int MODULES = 3;
    private static final int DEPLOYMENT_DESC = 4;
    private static final int MODULE_TYPE = 0;
    private static final int MODULE_LABEL = 1;
    private static final int MODULE_SEQUENCE = 2;
    private static final int CONTAINER = 3;
    private final String[] elements = new String[5];
    private final String[] deploymentDesc = new String[4];

    public StreamDeploymentsPath() {
        this.elements[0] = "deployments";
        this.elements[1] = "streams";
        this.elements[3] = "modules";
    }

    public StreamDeploymentsPath(String path) {
        Assert.hasText((String)path);
        String[] pathElements = path.split("\\/");
        int offset = -1;
        for (int i = 0; i < pathElements.length; ++i) {
            if (!pathElements[i].equals("deployments")) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IllegalArgumentException(String.format("Path '%s' does not include a '%s' element", path, "deployments"));
        }
        System.arraycopy(pathElements, offset, this.elements, 0, pathElements.length - offset);
        Assert.state((boolean)this.elements[0].equals("deployments"));
        Assert.state((boolean)this.elements[3].equals("modules"));
        if (this.elements[4] != null) {
            int deploymentDescCount = this.deploymentDesc.length;
            String[] deploymentElements = this.elements[4].split(" ")[0].split("\\.");
            Assert.state((deploymentElements.length == deploymentDescCount ? 1 : 0) != 0);
            System.arraycopy(deploymentElements, 0, this.deploymentDesc, 0, deploymentDescCount);
        }
    }

    public String getModuleInstanceAsString() {
        return String.format("%s.%s.%s", this.getModuleType(), this.getModuleLabel(), this.getModuleSequenceAsString());
    }

    public String getStreamName() {
        return this.elements[2];
    }

    public StreamDeploymentsPath setStreamName(String name) {
        this.elements[2] = name;
        return this;
    }

    public String getModuleType() {
        return this.deploymentDesc[0];
    }

    public StreamDeploymentsPath setModuleType(String type) {
        this.deploymentDesc[0] = type;
        return this;
    }

    public String getModuleLabel() {
        return this.deploymentDesc[1];
    }

    public StreamDeploymentsPath setModuleLabel(String label) {
        this.deploymentDesc[1] = label;
        return this;
    }

    public String getModuleSequenceAsString() {
        return this.deploymentDesc[2];
    }

    public int getModuleSequence() {
        return Integer.valueOf(this.deploymentDesc[2]);
    }

    public StreamDeploymentsPath setModuleSequence(String moduleSequence) {
        this.deploymentDesc[2] = moduleSequence;
        return this;
    }

    public String getContainer() {
        return this.deploymentDesc[3];
    }

    public StreamDeploymentsPath setContainer(String container) {
        this.deploymentDesc[3] = container;
        return this;
    }

    public String build() throws IllegalStateException {
        this.validate();
        this.elements[4] = String.format("%s.%s.%s.%s", this.deploymentDesc[0], this.deploymentDesc[1], this.deploymentDesc[2], this.deploymentDesc[3]);
        return Paths.build(this.elements);
    }

    private void validate() {
        Assert.state((boolean)StringUtils.hasText((String)this.elements[2]), (String)"Stream name missing");
        Assert.state((boolean)StringUtils.hasText((String)this.deploymentDesc[0]), (String)"Module type missing");
        Assert.state((boolean)StringUtils.hasText((String)this.deploymentDesc[1]), (String)"Module label missing");
        Assert.state((boolean)StringUtils.hasText((String)this.deploymentDesc[2]), (String)"Module sequence missing");
        Assert.state((boolean)StringUtils.hasText((String)this.deploymentDesc[3]), (String)"Container missing");
    }

    public String toString() {
        return this.build();
    }
}

