/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.core;

import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.xd.dirt.core.DeploymentUnit;
import org.springframework.xd.module.ModuleDescriptor;

public class Stream
implements DeploymentUnit {
    private final String name;
    private final LinkedList<ModuleDescriptor> descriptors;
    private final Map<String, String> deploymentProperties;

    private Stream(String name, LinkedList<ModuleDescriptor> descriptors, Map<String, String> deploymentProperties) {
        this.name = name;
        this.descriptors = descriptors;
        this.deploymentProperties = deploymentProperties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Deque<ModuleDescriptor> getModuleDescriptorsAsDeque() {
        return this.descriptors;
    }

    @Override
    public List<ModuleDescriptor> getModuleDescriptors() {
        return this.descriptors;
    }

    public Iterator<ModuleDescriptor> getDeploymentOrderIterator() {
        return this.descriptors.descendingIterator();
    }

    @Override
    public Map<String, String> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public String toString() {
        return "Stream{name='" + this.name + "'}";
    }

    public ModuleDescriptor getModuleDescriptor(String moduleLabel) throws IllegalStateException {
        for (ModuleDescriptor descriptor : this.descriptors) {
            if (!descriptor.getModuleLabel().equals(moduleLabel)) continue;
            return descriptor;
        }
        throw new IllegalStateException(String.format("Could not find module with label '%s' in the list of modules for stream '%s': %s", moduleLabel, this.getName(), this.getModuleDescriptors()));
    }

    public static class Builder {
        private String name;
        private Map<String, String> deploymentProperties = Collections.emptyMap();
        private LinkedList<ModuleDescriptor> moduleDescriptors = new LinkedList();

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setModuleDescriptors(Deque<ModuleDescriptor> descriptors) {
            this.moduleDescriptors.addAll(descriptors);
            return this;
        }

        public Builder setDeploymentProperties(Map<String, String> deploymentProperties) {
            this.deploymentProperties = deploymentProperties;
            return this;
        }

        public Stream build() {
            return new Stream(this.name, this.moduleDescriptors, this.deploymentProperties);
        }
    }
}

