/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.core;

import org.springframework.util.Assert;
import org.springframework.xd.dirt.zookeeper.Paths;

public class ModuleDeploymentsPath {
    private static final int DEPLOYMENTS = 0;
    private static final int MODULES = 1;
    private static final int ALLOCATED = 2;
    private static final int CONTAINER = 3;
    private static final int DEPLOYMENT_DESC = 4;
    private static final int DEPLOYMENT_UNIT_NAME = 0;
    private static final int MODULE_TYPE = 1;
    private static final int MODULE_LABEL = 2;
    private static final int MODULE_SEQUENCE = 3;
    private final String[] elements = new String[5];
    private final String[] deploymentDesc = new String[4];

    public ModuleDeploymentsPath() {
        this.elements[0] = "deployments";
        this.elements[1] = "modules";
        this.elements[2] = "allocated";
    }

    public ModuleDeploymentsPath(String path) {
        Assert.hasText((String)path);
        String[] pathElements = path.split("\\/");
        int offset = -1;
        for (int i = 0; i < pathElements.length; ++i) {
            if (!pathElements[i].equals("deployments")) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IllegalArgumentException(String.format("Path '%s' does not include a '%s' element", path, "deployments"));
        }
        System.arraycopy(pathElements, offset, this.elements, 0, this.elements.length);
        Assert.noNullElements((Object[])this.elements);
        Assert.state((boolean)this.elements[0].equals("deployments"));
        String[] deploymentElements = this.elements[4].split(" ")[0].split("\\.");
        Assert.state((deploymentElements.length == 4 ? 1 : 0) != 0);
        System.arraycopy(deploymentElements, 0, this.deploymentDesc, 0, this.deploymentDesc.length);
    }

    public String getContainer() {
        return this.elements[3];
    }

    public ModuleDeploymentsPath setContainer(String container) {
        this.elements[3] = container;
        return this;
    }

    public String getDeploymentUnitName() {
        return this.deploymentDesc[0];
    }

    public ModuleDeploymentsPath setDeploymentUnitName(String deploymentUnitName) {
        this.deploymentDesc[0] = deploymentUnitName;
        return this;
    }

    public String getModuleType() {
        return this.deploymentDesc[1];
    }

    public ModuleDeploymentsPath setModuleType(String moduleType) {
        this.deploymentDesc[1] = moduleType;
        return this;
    }

    public String getModuleLabel() {
        return this.deploymentDesc[2];
    }

    public ModuleDeploymentsPath setModuleLabel(String moduleLabel) {
        this.deploymentDesc[2] = moduleLabel;
        return this;
    }

    public String getModuleSequenceAsString() {
        return this.deploymentDesc[3];
    }

    public int getModuleSequence() {
        return Integer.valueOf(this.deploymentDesc[3]);
    }

    public ModuleDeploymentsPath setModuleSequence(String moduleSequence) {
        this.deploymentDesc[3] = moduleSequence;
        return this;
    }

    public String build() {
        this.elements[4] = String.format("%s.%s.%s.%s", this.deploymentDesc[0], this.deploymentDesc[1], this.deploymentDesc[2], this.deploymentDesc[3]);
        return Paths.build(this.elements);
    }

    public String toString() {
        return this.build();
    }
}

