/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.zookeeper.Paths;

public class ModuleDeploymentRequestsPath {
    private static final int DEPLOYMENTS = 0;
    private static final int MODULES = 1;
    private static final int REQUESTED = 2;
    private static final int DEPLOYMENT_DESC = 3;
    private static final int DEPLOYMENT_UNIT_NAME = 0;
    private static final int MODULE_TYPE = 1;
    private static final int MODULE_LABEL = 2;
    private static final int MODULE_SEQUENCE = 3;
    private final String[] elements = new String[4];
    private final String[] deploymentDesc = new String[4];

    public ModuleDeploymentRequestsPath() {
        this.elements[0] = "deployments";
        this.elements[1] = "modules";
        this.elements[2] = "requested";
    }

    public ModuleDeploymentRequestsPath(String path) {
        Assert.hasText((String)path);
        String[] pathElements = path.split("\\/");
        int offset = -1;
        for (int i = 0; i < pathElements.length; ++i) {
            if (!pathElements[i].equals("deployments")) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IllegalArgumentException(String.format("Path '%s' does not include a '%s' element", path, "deployments"));
        }
        System.arraycopy(pathElements, offset, this.elements, 0, this.elements.length);
        Assert.noNullElements((Object[])this.elements);
        Assert.state((boolean)this.elements[0].equals("deployments"));
        Assert.state((boolean)this.elements[1].equals("modules"));
        Assert.state((boolean)this.elements[2].equals("requested"));
        if (this.elements[3] != null) {
            int deploymentDescCount = this.deploymentDesc.length;
            String[] deploymentElements = this.elements[3].split(" ")[0].split("\\.");
            Assert.state((deploymentElements.length == deploymentDescCount ? 1 : 0) != 0);
            System.arraycopy(deploymentElements, 0, this.deploymentDesc, 0, deploymentDescCount);
        }
    }

    public String getModuleInstanceAsString() {
        return String.format("%s.%s.%s", this.getModuleType(), this.getModuleLabel(), this.getModuleSequence());
    }

    public String getDeploymentUnitName() {
        return this.deploymentDesc[0];
    }

    public ModuleDeploymentRequestsPath setDeploymentUnitName(String deploymentUnitName) {
        this.deploymentDesc[0] = deploymentUnitName;
        return this;
    }

    public String getModuleType() {
        return this.deploymentDesc[1];
    }

    public ModuleDeploymentRequestsPath setModuleType(String moduleType) {
        this.deploymentDesc[1] = moduleType;
        return this;
    }

    public String getModuleLabel() {
        return this.deploymentDesc[2];
    }

    public ModuleDeploymentRequestsPath setModuleLabel(String moduleLabel) {
        this.deploymentDesc[2] = moduleLabel;
        return this;
    }

    public String getModuleSequence() {
        return this.deploymentDesc[3];
    }

    public ModuleDeploymentRequestsPath setModuleSequence(String moduleSequence) {
        this.deploymentDesc[3] = moduleSequence;
        return this;
    }

    public String build() {
        this.elements[3] = String.format("%s.%s.%s.%s", this.deploymentDesc[0], this.deploymentDesc[1], this.deploymentDesc[2], this.deploymentDesc[3]);
        return Paths.build(this.elements);
    }

    public String toString() {
        return this.build();
    }

    public static List<ModuleDeploymentRequestsPath> getModulesForDeploymentUnit(Collection<ModuleDeploymentRequestsPath> requestedModulesPaths, String unitName) {
        ArrayList<ModuleDeploymentRequestsPath> pathsToReturn = new ArrayList<ModuleDeploymentRequestsPath>();
        for (ModuleDeploymentRequestsPath path : requestedModulesPaths) {
            if (!path.getDeploymentUnitName().equals(unitName)) continue;
            pathsToReturn.add(path);
        }
        return pathsToReturn;
    }
}

