/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.xd.dirt.core.DeploymentUnit;
import org.springframework.xd.module.ModuleDescriptor;

public class Job
implements DeploymentUnit {
    private final String name;
    private final ModuleDescriptor descriptor;
    private final Map<String, String> deploymentProperties;

    private Job(String name, ModuleDescriptor descriptor, Map<String, String> deploymentProperties) {
        this.name = name;
        this.descriptor = descriptor;
        this.deploymentProperties = deploymentProperties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ModuleDescriptor getJobModuleDescriptor() {
        return this.descriptor;
    }

    @Override
    public List<ModuleDescriptor> getModuleDescriptors() {
        return Collections.singletonList(this.descriptor);
    }

    @Override
    public Map<String, String> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public String toString() {
        return "Job{name='" + this.name + "'}";
    }

    public static class Builder {
        private String name;
        private Map<String, String> deploymentProperties = Collections.emptyMap();
        private ModuleDescriptor moduleDescriptor;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setModuleDescriptor(ModuleDescriptor descriptor) {
            this.moduleDescriptor = descriptor;
            return this;
        }

        public Builder setDeploymentProperties(Map<String, String> deploymentProperties) {
            this.deploymentProperties = deploymentProperties;
            return this;
        }

        public Job build() {
            return new Job(this.name, this.moduleDescriptor, this.deploymentProperties);
        }
    }
}

