/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DeploymentUnitStatus {
    private static final String STATE_KEY = "state";
    private static final String ERROR_DESCRIPTION = "errorDescription";
    private final State state;
    private final String errorDescription;

    public DeploymentUnitStatus(State state) {
        this(state, null);
    }

    public DeploymentUnitStatus(State state, String errorDescription) {
        Assert.notNull((Object)((Object)state));
        this.state = state;
        this.errorDescription = errorDescription;
    }

    public DeploymentUnitStatus(Map<String, String> mapStatus) {
        String stateString = mapStatus.get(STATE_KEY);
        Assert.state((boolean)StringUtils.hasText((String)stateString));
        this.state = State.valueOf(stateString.toLowerCase());
        this.errorDescription = mapStatus.get(ERROR_DESCRIPTION);
    }

    public State getState() {
        return this.state;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STATE_KEY, this.state.toString());
        if (StringUtils.hasText((String)this.errorDescription)) {
            map.put(ERROR_DESCRIPTION, this.errorDescription);
        }
        return Collections.unmodifiableMap(map);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DeploymentStatus{state=");
        builder.append((Object)this.state);
        if (StringUtils.hasText((String)this.errorDescription)) {
            builder.append(",error(s)=").append(this.errorDescription);
        }
        builder.append("}");
        return builder.toString();
    }

    public static enum State {
        undeployed,
        deploying,
        deployed,
        incomplete,
        failed,
        undeploying,
        unknown;

    }
}

