/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.core;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.xd.module.ModuleDefinition;

public abstract class BaseDefinition
implements Comparable<BaseDefinition> {
    private String definition;
    private String name;
    private List<ModuleDefinition> moduleDefinitions = new ArrayList<ModuleDefinition>();

    protected BaseDefinition() {
    }

    public BaseDefinition(String name, String definition) {
        Assert.hasText((String)name, (String)"Name can not be empty");
        Assert.hasText((String)definition, (String)"Definition can not be empty");
        this.name = name;
        this.definition = definition;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getName() {
        return this.name;
    }

    public void setModuleDefinitions(List<ModuleDefinition> moduleDefinitions) {
        this.moduleDefinitions = moduleDefinitions;
    }

    public List<ModuleDefinition> getModuleDefinitions() {
        return this.moduleDefinitions;
    }

    public String toString() {
        return "BaseDefinition [definition=" + this.definition + ", name=" + this.name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseDefinition other = (BaseDefinition)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(BaseDefinition otherBaseDefinition) {
        return this.name.compareTo(otherBaseDefinition.name);
    }
}

