/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.container.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ThreadUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.cluster.Container;
import org.springframework.xd.dirt.cluster.NoSuchContainerException;
import org.springframework.xd.dirt.container.store.ContainerRepository;
import org.springframework.xd.dirt.container.store.DetailedContainer;
import org.springframework.xd.dirt.module.store.ModuleMetadata;
import org.springframework.xd.dirt.module.store.ZooKeeperModuleMetadataRepository;
import org.springframework.xd.dirt.rest.PasswordUtils;
import org.springframework.xd.dirt.util.PagingUtility;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class ZooKeeperContainerRepository
implements ContainerRepository,
ApplicationListener<ApplicationEvent> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ZooKeeperConnection zkConnection;
    private final ZooKeeperModuleMetadataRepository zkModuleMetadataRepository;
    private final PagingUtility<Container> pagingUtility = new PagingUtility();
    private final PagingUtility<DetailedContainer> detailedContainersUtil = new PagingUtility();
    private final AtomicReference<PathChildrenCache> cacheRef = new AtomicReference();

    @Autowired
    public ZooKeeperContainerRepository(ZooKeeperConnection zkConnection, ZooKeeperModuleMetadataRepository moduleMetadataRepository) {
        this.zkConnection = zkConnection;
        this.zkModuleMetadataRepository = moduleMetadataRepository;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextStoppedEvent || event instanceof ContextClosedEvent) {
            this.closeCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCache() {
        PathChildrenCache cache = this.cacheRef.get();
        if (cache != null) {
            try {
                cache.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.cacheRef.compareAndSet(cache, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathChildrenCache ensureCache() {
        PathChildrenCache cache;
        if (this.cacheRef.get() == null) {
            AtomicReference<PathChildrenCache> atomicReference = this.cacheRef;
            synchronized (atomicReference) {
                if (this.cacheRef.get() == null) {
                    CuratorFramework client = this.zkConnection.getClient();
                    PathChildrenCache cache2 = new PathChildrenCache(client, "containers", true, ThreadUtils.newThreadFactory((String)"ContainerCache"));
                    cache2.getListenable().addListener((Object)new PathChildrenCacheListener(){

                        public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
                            ZooKeeperUtils.logCacheEvent(ZooKeeperContainerRepository.this.logger, event);
                            if (event.getType() == PathChildrenCacheEvent.Type.CONNECTION_SUSPENDED || event.getType() == PathChildrenCacheEvent.Type.CONNECTION_LOST) {
                                ZooKeeperContainerRepository.this.closeCache();
                            }
                        }
                    });
                    try {
                        Paths.ensurePath(client, "containers");
                        this.cacheRef.set(cache2);
                        cache2.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
                    }
                    catch (Exception e) {
                        try {
                            cache2.close();
                        }
                        catch (Exception ce) {
                        }
                        finally {
                            this.cacheRef.compareAndSet(cache2, null);
                        }
                        throw ZooKeeperUtils.wrapThrowable(e);
                    }
                }
            }
        }
        Assert.state(((cache = this.cacheRef.get()) != null ? 1 : 0) != 0, (String)"Container cache not initialized (likely as a result of a ZooKeeper connection error)");
        return cache;
    }

    public Iterable<Container> findAll(Sort sort) {
        return this.findAll();
    }

    public Page<Container> findAll(Pageable pageable) {
        return this.pagingUtility.getPagedData(pageable, (List<Container>)this.findAll());
    }

    public <S extends Container> S save(S entity) {
        CuratorFramework client = this.zkConnection.getClient();
        String path = Paths.build("containers", entity.getName());
        try {
            ((ACLBackgroundPathAndBytesable)client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, ZooKeeperUtils.mapToBytes(entity.getAttributes()));
            return entity;
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    @Override
    public void update(Container entity) {
        CuratorFramework client = this.zkConnection.getClient();
        String path = Paths.build("containers", entity.getName());
        try {
            Stat stat = (Stat)client.checkExists().forPath(path);
            if (stat == null) {
                throw new NoSuchContainerException("Could not find container with id " + entity.getName());
            }
            client.setData().forPath(path, ZooKeeperUtils.mapToBytes(entity.getAttributes()));
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e, e.getMessage());
        }
    }

    public <S extends Container> Iterable<S> save(Iterable<S> entities) {
        ArrayList<Container> results = new ArrayList<Container>();
        for (Container entity : entities) {
            results.add(this.save(entity));
        }
        return results;
    }

    public Container findOne(String id) {
        Container container = null;
        String containerPath = this.path(id);
        ChildData childData = this.ensureCache().getCurrentData(containerPath);
        byte[] data = null;
        if (childData != null) {
            data = childData.getData();
        }
        if (data != null) {
            container = new Container(id, ZooKeeperUtils.bytesToMap(data));
        }
        return container;
    }

    public boolean exists(String id) {
        return this.ensureCache().getCurrentData(this.path(id)) != null;
    }

    public List<Container> findAll() {
        ArrayList<Container> results = new ArrayList<Container>();
        ArrayList children = new ArrayList(this.ensureCache().getCurrentData());
        Collections.sort(children, new Comparator<ChildData>(){

            @Override
            public int compare(ChildData c1, ChildData c2) {
                long t2;
                long t1 = c1.getStat().getCtime();
                return t1 < (t2 = c2.getStat().getCtime()) ? -1 : (t1 == t2 ? 0 : 1);
            }
        });
        for (ChildData childData : children) {
            results.add(this.findOne(Paths.stripPath(childData.getPath())));
        }
        return results;
    }

    public Iterable<Container> findAll(Iterable<String> ids) {
        ArrayList<Container> results = new ArrayList<Container>();
        for (String id : ids) {
            Container entity = this.findOne(id);
            if (entity == null) continue;
            results.add(entity);
        }
        return results;
    }

    @Override
    public Page<DetailedContainer> findAllRuntimeContainers(Pageable pageable, boolean maskSensitiveProperties) {
        ArrayList<DetailedContainer> results = new ArrayList<DetailedContainer>();
        Iterable containers = this.findAll();
        for (Container container : containers) {
            DetailedContainer runtimeContainer = new DetailedContainer(container);
            Iterable deployedModules = this.zkModuleMetadataRepository.findAllByContainerId(container.getName());
            if (maskSensitiveProperties) {
                for (ModuleMetadata moduleMetadata : deployedModules) {
                    PasswordUtils.maskPropertiesIfNecessary(moduleMetadata.getModuleOptions());
                }
            }
            runtimeContainer.setDeployedModules((List<ModuleMetadata>)deployedModules);
            runtimeContainer.setDeploymentSize(deployedModules.size());
            results.add(runtimeContainer);
        }
        return this.detailedContainersUtil.getPagedData(pageable, results);
    }

    public long count() {
        return this.ensureCache().getCurrentData().size();
    }

    public void delete(String id) {
    }

    public void delete(Container entity) {
    }

    public void delete(Iterable<? extends Container> entities) {
    }

    public void deleteAll() {
    }

    public Iterable<Container> findAllInRange(String from, boolean fromInclusive, String to, boolean toInclusive) {
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    private String path(String id) {
        return Paths.build("containers", id);
    }
}

