/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.container.store;

import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.xd.dirt.cluster.Admin;
import org.springframework.xd.dirt.cluster.NoSuchContainerException;
import org.springframework.xd.dirt.container.store.AdminRepository;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class ZooKeeperAdminRepository
implements AdminRepository {
    private final ZooKeeperConnection zkConnection;

    @Autowired
    public ZooKeeperAdminRepository(ZooKeeperConnection zkConnection) {
        this.zkConnection = zkConnection;
    }

    @Override
    public Admin save(Admin entity) {
        CuratorFramework client = this.zkConnection.getClient();
        String path = Paths.build("admins", entity.getName());
        try {
            ((ACLBackgroundPathAndBytesable)client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path, ZooKeeperUtils.mapToBytes(entity.getAttributes()));
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
        return entity;
    }

    @Override
    public void update(Admin entity) {
        CuratorFramework client = this.zkConnection.getClient();
        String path = Paths.build("admins", entity.getName());
        try {
            Stat stat = (Stat)client.checkExists().forPath(path);
            if (stat == null) {
                throw new NoSuchContainerException("Could not find admin with id " + entity.getName());
            }
            client.setData().forPath(path, ZooKeeperUtils.mapToBytes(entity.getAttributes()));
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e, e.getMessage());
        }
    }

    @Override
    public boolean exists(String id) {
        try {
            return null != this.zkConnection.getClient().checkExists().forPath(this.path(id));
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    @Override
    public List<Admin> findAll() {
        ArrayList<Admin> results = new ArrayList<Admin>();
        try {
            List children = (List)this.zkConnection.getClient().getChildren().forPath(Paths.build("admins"));
            for (String child : children) {
                byte[] data = (byte[])this.zkConnection.getClient().getData().forPath(Paths.build("admins", child));
                if (data == null || data.length <= 0) continue;
                results.add(new Admin(child, ZooKeeperUtils.bytesToMap(data)));
            }
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
        return results;
    }

    @Override
    public Admin findOne(String id) {
        try {
            byte[] data = (byte[])this.zkConnection.getClient().getData().forPath(Paths.build("admins", id));
            if (data != null && data.length > 0) {
                return new Admin(id, ZooKeeperUtils.bytesToMap(data));
            }
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
        return null;
    }

    private String path(String id) {
        return Paths.build("admins", id);
    }
}

