/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.container.initializer;

import java.io.IOException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.groovy.GroovyBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.container.initializer.OrderedContextInitializer;

public abstract class AbstractResourceBeanDefinitionProvider
implements OrderedContextInitializer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Pattern prefix = Pattern.compile("^[a-z*]+:");

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver((ResourceLoader)context);
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context.getBeanFactory());
        xmlReader.setEnvironment((Environment)context.getEnvironment());
        GroovyBeanDefinitionReader groovyReader = new GroovyBeanDefinitionReader((BeanDefinitionRegistry)context.getBeanFactory());
        groovyReader.setEnvironment((Environment)context.getEnvironment());
        for (String locationPattern : this.getLocations()) {
            try {
                Resource[] resources = resourceResolver.getResources(locationPattern);
                this.logger.info("resolving resource location pattern {}", (Object)locationPattern);
                for (Resource resource : resources) {
                    if (resource.getFilename() == null) continue;
                    if (resource.getFilename().endsWith(".xml")) {
                        this.logger.info("loading XD extensions from {}", (Object)resource.getFilename());
                        xmlReader.loadBeanDefinitions(resource);
                        continue;
                    }
                    if (!resource.getFilename().endsWith(".groovy")) continue;
                    groovyReader.loadBeanDefinitions(resource);
                }
            }
            catch (IOException e) {
                this.logger.warn("could not resolve resources for {}", (Object)locationPattern);
            }
        }
    }

    protected abstract String getExtensionsLocations();

    protected String[] getLocations() {
        String[] locations = StringUtils.commaDelimitedListToStringArray((String)this.getExtensionsLocations());
        for (int i = 0; i < locations.length; ++i) {
            if (!this.prefix.matcher(locations[i]).find()) {
                locations[i] = "classpath*:" + locations[i];
            }
            if (!locations[i].endsWith("/")) {
                locations[i] = locations[i] + "/";
            }
            locations[i] = locations[i] + "**/*.*";
        }
        return locations;
    }
}

