/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.container.initializer;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.container.initializer.OrderedContextInitializer;

public abstract class AbstractComponentScanningBeanDefinitionProvider
implements OrderedContextInitializer {
    public void onApplicationEvent(ApplicationPreparedEvent event) {
        if (StringUtils.hasText((String)this.getExtensionsBasePackages())) {
            AnnotationConfigApplicationContext context = (AnnotationConfigApplicationContext)event.getApplicationContext();
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(true, (Environment)context.getEnvironment());
            for (String basePackage : StringUtils.commaDelimitedListToStringArray((String)this.getExtensionsBasePackages())) {
                for (BeanDefinition bean : componentProvider.findCandidateComponents(basePackage)) {
                    context.registerBeanDefinition(BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)bean, (BeanDefinitionRegistry)context), bean);
                }
            }
        }
    }

    protected abstract String getExtensionsBasePackages();

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

