/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.container.decryptor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.xd.dirt.container.initializer.OrderedContextInitializer;

public class PropertiesDecryptor
implements OrderedContextInitializer,
ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(PropertiesDecryptor.class);
    public static final String DECRYPTED_PROPERTY_SOURCE_NAME = "decrypted";
    public static final String DECRYPTOR_BEAN_NAME = "propertiesDecryptor";
    private int order = -2147483633;
    private TextEncryptor decryptor;
    private boolean failOnError = true;
    private ApplicationContext applicationContext;

    public PropertiesDecryptor(TextEncryptor decryptor) {
        this.decryptor = decryptor;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        ConfigurableEnvironment environment;
        MutablePropertySources propertySources;
        Map<String, Object> map;
        if (this.decryptor == null) {
            return;
        }
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        if (!applicationContext.equals(this.applicationContext)) {
            return;
        }
        if (!applicationContext.containsBean(DECRYPTOR_BEAN_NAME)) {
            applicationContext.getBeanFactory().registerSingleton(DECRYPTOR_BEAN_NAME, (Object)this.decryptor);
        }
        if (!(map = this.decrypt((PropertySources)(propertySources = (environment = applicationContext.getEnvironment()).getPropertySources()))).isEmpty()) {
            this.insert(propertySources, new MapPropertySource(DECRYPTED_PROPERTY_SOURCE_NAME, map));
        }
    }

    private void insert(MutablePropertySources propertySources, MapPropertySource propertySource) {
        propertySources.addFirst((PropertySource)propertySource);
    }

    public Map<String, Object> decrypt(PropertySources propertySources) {
        LinkedHashMap<String, Object> overrides = new LinkedHashMap<String, Object>();
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        for (PropertySource source : propertySources) {
            sources.add(0, source);
        }
        for (PropertySource source : sources) {
            this.decrypt(source, overrides);
        }
        return overrides;
    }

    private Map<String, Object> decrypt(PropertySource<?> source) {
        LinkedHashMap<String, Object> overrides = new LinkedHashMap<String, Object>();
        this.decrypt(source, overrides);
        return overrides;
    }

    private void decrypt(PropertySource<?> source, Map<String, Object> overrides) {
        if (source instanceof EnumerablePropertySource) {
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            for (String key : enumerable.getPropertyNames()) {
                String value;
                Object property = source.getProperty(key);
                if (property == null || !(value = property.toString()).startsWith("{cipher}")) continue;
                value = value.substring("{cipher}".length());
                try {
                    value = this.decryptor.decrypt(value);
                    logger.debug("Decrypted: key=" + key);
                }
                catch (Exception e) {
                    String message = "Cannot decrypt: key=" + key;
                    if (this.failOnError) {
                        throw new IllegalStateException(message, e);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.warn(message, (Throwable)e);
                    } else {
                        logger.warn(message);
                    }
                    value = "";
                }
                overrides.put(key, value);
            }
        } else if (source instanceof CompositePropertySource) {
            for (PropertySource nested : ((CompositePropertySource)source).getPropertySources()) {
                this.decrypt(nested, overrides);
            }
        } else {
            logger.debug("ignored property source {} {}", (Object)source.getName(), (Object)source.getClass().getName());
        }
    }
}

