/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.container.decryptor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.xd.dirt.container.decryptor.PropertiesDecryptor;

public class DecryptorContext {
    private static Logger logger = LoggerFactory.getLogger(DecryptorContext.class);
    private PropertiesDecryptor propertiesDecryptor;

    public DecryptorContext() {
        TextEncryptor textEncryptor;
        block2: {
            ConfigurableApplicationContext decryptorContext = new SpringApplicationBuilder(new Object[]{DecryptorContextConfiguration.class, PropertyPlaceholderAutoConfiguration.class}).headless(true).web(false).showBanner(false).run(new String[0]);
            textEncryptor = null;
            try {
                textEncryptor = (TextEncryptor)decryptorContext.getBean(TextEncryptor.class);
                logger.debug("Registered TextEncryptor {}", (Object)textEncryptor.getClass().getName());
            }
            catch (NoSuchBeanDefinitionException e) {
                if (!(e instanceof NoUniqueBeanDefinitionException)) break block2;
                throw e;
            }
        }
        this.propertiesDecryptor = new PropertiesDecryptor(textEncryptor);
    }

    public PropertiesDecryptor propertiesDecryptor() {
        return this.propertiesDecryptor;
    }

    @Configuration
    @ComponentScan(basePackages={"spring.xd.ext.encryption"})
    static class DecryptorContextConfiguration {
        DecryptorContextConfiguration() {
        }
    }
}

