/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.cluster;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ContainerAttributes
implements Map<String, String>,
Comparable<ContainerAttributes> {
    public static final String CONTAINER_ID_KEY = "id";
    public static final String HOST_KEY = "host";
    public static final String PROCESS_ID_KEY = "pid";
    public static final String GROUPS_KEY = "groups";
    public static final String IP_ADDRESS_KEY = "ip";
    public static final String MGMT_PORT_KEY = "managementPort";
    private final List<String> commonAttributeKeys = Arrays.asList("id", "pid", "host", "ip", "groups");
    private final Map<String, String> map = new ConcurrentHashMap<String, String>();

    public ContainerAttributes() {
        this(UUID.randomUUID().toString());
    }

    public ContainerAttributes(String id) {
        Assert.hasText((String)id, (String)"id is required");
        this.put(CONTAINER_ID_KEY, id);
    }

    public ContainerAttributes(Map<? extends String, ? extends String> attributes) {
        Assert.notNull(attributes, (String)"attributes must not be null");
        if (!attributes.containsKey(CONTAINER_ID_KEY)) {
            this.put(CONTAINER_ID_KEY, UUID.randomUUID().toString());
        }
        this.putAll(attributes);
    }

    public String getId() {
        return this.get(CONTAINER_ID_KEY);
    }

    public String getHost() {
        return this.get(HOST_KEY);
    }

    public String getIp() {
        return this.get(IP_ADDRESS_KEY);
    }

    public String getManagementPort() {
        return this.get(MGMT_PORT_KEY);
    }

    public int getPid() {
        return Integer.parseInt(this.get(PROCESS_ID_KEY));
    }

    public Set<String> getGroups() {
        String groups = this.get(GROUPS_KEY);
        Set groupSet = StringUtils.hasText((String)groups) ? StringUtils.commaDelimitedListToSet((String)groups) : new HashSet();
        return Collections.unmodifiableSet(groupSet);
    }

    public ContainerAttributes setPid(Integer pid) {
        this.put(PROCESS_ID_KEY, String.valueOf(pid));
        return this;
    }

    public ContainerAttributes setHost(String host) {
        this.put(HOST_KEY, host);
        return this;
    }

    public ContainerAttributes setIp(String ip) {
        this.put(IP_ADDRESS_KEY, ip);
        return this;
    }

    public ContainerAttributes setManagementPort(String mgmtPort) {
        this.put(MGMT_PORT_KEY, mgmtPort);
        return this;
    }

    public Map<String, String> getCustomAttributes() {
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        for (String key : this.keySet()) {
            if (this.commonAttributeKeys.contains(key)) continue;
            customAttributes.put(key, this.get(key));
        }
        return customAttributes;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.map.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.map.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int compareTo(ContainerAttributes other) {
        return this.getId().compareTo(other.getId());
    }
}

