/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.cluster;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.cluster.ContainerAttributes;

public class Container
implements Comparable<Container> {
    private final String name;
    private final ContainerAttributes attributes;
    private final Set<String> groups;

    public Container(String name, Map<String, String> attributes) {
        Assert.hasText((String)name);
        this.name = name;
        this.attributes = new ContainerAttributes(attributes);
        String groupList = attributes.get("groups");
        if (groupList == null) {
            this.groups = Collections.emptySet();
        } else {
            HashSet set = new HashSet();
            Collections.addAll(set, StringUtils.tokenizeToStringArray((String)groupList, (String)","));
            this.groups = Collections.unmodifiableSet(set);
        }
    }

    public String getName() {
        return this.name;
    }

    public ContainerAttributes getAttributes() {
        return this.attributes;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    public int compareTo(Container other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object o) {
        return o instanceof Container && this.name.equals(((Container)o).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Container{name='" + this.name + '\'' + ", attributes=" + this.attributes + '}';
    }
}

