/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.cluster;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public class AdminAttributes
implements Map<String, String>,
Comparable<AdminAttributes> {
    public static final String ADMIN_ID_KEY = "id";
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    public static final String PROCESS_ID_KEY = "pid";
    public static final String IP_ADDRESS_KEY = "ip";
    public static final String MGMT_PORT_KEY = "managementPort";
    private final List<String> commonAttributeKeys = Arrays.asList("id", "pid", "host", "port", "ip");
    private final Map<String, String> map = new ConcurrentHashMap<String, String>();

    public AdminAttributes() {
        this(UUID.randomUUID().toString());
    }

    public AdminAttributes(String id) {
        Assert.hasText((String)id, (String)"id is required");
        this.put(ADMIN_ID_KEY, id);
    }

    public AdminAttributes(Map<? extends String, ? extends String> attributes) {
        Assert.notNull(attributes, (String)"attributes must not be null");
        if (!attributes.containsKey(ADMIN_ID_KEY)) {
            this.put(ADMIN_ID_KEY, UUID.randomUUID().toString());
        }
        this.putAll(attributes);
    }

    public String getId() {
        return this.get(ADMIN_ID_KEY);
    }

    public String getHost() {
        return this.get(HOST_KEY);
    }

    public int getPort() {
        return Integer.parseInt(this.get(PORT_KEY));
    }

    public String getIp() {
        return this.get(IP_ADDRESS_KEY);
    }

    public int getManagementPort() {
        return Integer.parseInt(this.get(MGMT_PORT_KEY));
    }

    public int getPid() {
        return Integer.parseInt(this.get(PROCESS_ID_KEY));
    }

    public AdminAttributes setPid(Integer pid) {
        this.put(PROCESS_ID_KEY, String.valueOf(pid));
        return this;
    }

    public AdminAttributes setHost(String host) {
        this.put(HOST_KEY, host);
        return this;
    }

    public AdminAttributes setPort(Integer port) {
        this.put(PORT_KEY, String.valueOf(port));
        return this;
    }

    public AdminAttributes setIp(String ip) {
        this.put(IP_ADDRESS_KEY, ip);
        return this;
    }

    public AdminAttributes setManagementPort(Integer mgmtPort) {
        this.put(MGMT_PORT_KEY, String.valueOf(mgmtPort));
        return this;
    }

    public Map<String, String> getCustomAttributes() {
        HashMap<String, String> customAttributes = new HashMap<String, String>();
        for (String key : this.keySet()) {
            if (this.commonAttributeKeys.contains(key)) continue;
            customAttributes.put(key, this.get(key));
        }
        return customAttributes;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.map.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.map.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int compareTo(AdminAttributes other) {
        return this.getId().compareTo(other.getId());
    }
}

