/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.batch;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.plugins.job.support.JobLaunchingJobRepositoryFactoryBean;

@Component
public class RuntimeBatchConfigurer
implements BatchConfigurer {
    private DataSource dataSource;
    private PlatformTransactionManager transactionManager;
    private JobRepository jobRepository;
    private JobLauncher jobLauncher;
    private JobExplorer jobExplorer;
    private String isolationLevel = "ISOLATION_READ_COMMITTED";
    private Integer clobType = null;
    private String dbType = null;
    private int maxVarCharLength = 2500;
    private String tablePrefix = "BATCH_";
    private boolean validateTransactionState = true;
    public static final String DEFAULT_ISOLATION_LEVEL = "ISOLATION_READ_COMMITTED";

    @Autowired(required=true)
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.transactionManager = new DataSourceTransactionManager(dataSource);
    }

    protected RuntimeBatchConfigurer() {
    }

    public RuntimeBatchConfigurer(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    public JobExplorer getJobExplorer() {
        return this.jobExplorer;
    }

    @PostConstruct
    public void initialize() {
        Assert.notNull((Object)this.dataSource, (String)"No dataSource was provided for Batch runtime configuration");
        try {
            this.jobRepository = this.createJobRepository();
            this.jobExplorer = this.createJobExplorer();
            this.jobLauncher = this.createJobLauncher();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to initialize Spring Batch", ex);
        }
    }

    private JobExplorer createJobExplorer() throws Exception {
        JobExplorerFactoryBean jobExplorerFactoryBean = new JobExplorerFactoryBean();
        jobExplorerFactoryBean.setDataSource(this.dataSource);
        jobExplorerFactoryBean.afterPropertiesSet();
        return jobExplorerFactoryBean.getObject();
    }

    private JobLauncher createJobLauncher() throws Exception {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.createLaunchingJobRepository());
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }

    private JobRepository createLaunchingJobRepository() throws Exception {
        JobLaunchingJobRepositoryFactoryBean factory = new JobLaunchingJobRepositoryFactoryBean();
        factory.setDataSource(this.dataSource);
        if (this.dbType != null) {
            factory.setDatabaseType(this.dbType);
        }
        if (this.clobType != null) {
            factory.setClobType(this.clobType);
        }
        factory.setTransactionManager(this.transactionManager);
        factory.setIsolationLevelForCreate(this.isolationLevel);
        factory.setMaxVarCharLength(this.maxVarCharLength);
        factory.setTablePrefix(this.tablePrefix);
        factory.setValidateTransactionState(this.validateTransactionState);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    protected JobRepository createJobRepository() throws Exception {
        JobRepositoryFactoryBean factory = this.createJobRepositoryFactoryBean();
        factory.setDataSource(this.dataSource);
        if (this.dbType != null) {
            factory.setDatabaseType(this.dbType);
        }
        if (this.clobType != null) {
            factory.setClobType(this.clobType.intValue());
        }
        factory.setTransactionManager(this.transactionManager);
        factory.setIsolationLevelForCreate(this.isolationLevel);
        factory.setMaxVarCharLength(this.maxVarCharLength);
        factory.setTablePrefix(this.tablePrefix);
        factory.setValidateTransactionState(this.validateTransactionState);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    JobRepositoryFactoryBean createJobRepositoryFactoryBean() {
        return new JobRepositoryFactoryBean();
    }

    public void setIsolationLevel(String isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public void setClobType(Integer clobType) {
        this.clobType = clobType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setMaxVarCharLength(int maxVarCharLength) {
        this.maxVarCharLength = maxVarCharLength;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setValidateTransactionState(boolean validateTransactionState) {
        this.validateTransactionState = validateTransactionState;
    }
}

