/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.batch.hsqldb.server;

import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchDatabaseInitializer;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.integration.IntegrationAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.xd.batch.XdBatchDatabaseInitializer;
import org.springframework.xd.batch.hsqldb.server.HsqlDatasourceConfiguration;

@Configuration
@EnableAutoConfiguration(exclude={BatchAutoConfiguration.class, IntegrationAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class})
@EnableConfigurationProperties(value={BatchProperties.class})
public class HsqlServerApplication {
    public static final String HSQLDBSERVER_PROFILE = "hsqldbServer";

    public static void main(String[] args) {
        new HsqlServerApplication().run(args);
    }

    public void run(String ... args) {
        new SpringApplicationBuilder(new Object[]{HsqlDatasourceConfiguration.class}).profiles(new String[]{HSQLDBSERVER_PROFILE}).child(new Object[]{HsqlServerApplication.class}).web(false).showBanner(false).run(args);
    }

    @Bean
    public BatchDatabaseInitializer batchDatabaseInitializer() {
        return new XdBatchDatabaseInitializer();
    }
}

