/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.redis;

import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.retry.RetryOperations;
import org.springframework.xd.analytics.metrics.core.Gauge;
import org.springframework.xd.analytics.metrics.core.GaugeRepository;
import org.springframework.xd.analytics.metrics.redis.AbstractRedisMetricRepository;

public class RedisGaugeRepository
extends AbstractRedisMetricRepository<Gauge, Long>
implements GaugeRepository {
    public RedisGaugeRepository(RedisConnectionFactory connectionFactory, RetryOperations retryOperations) {
        this(connectionFactory, "gauges.", retryOperations);
    }

    public RedisGaugeRepository(RedisConnectionFactory connectionFactory, String gaugePrefix, RetryOperations retryOperations) {
        super(connectionFactory, gaugePrefix, Long.class, retryOperations);
    }

    @Override
    Gauge create(String name, Long value) {
        return new Gauge(name, value);
    }

    @Override
    Long defaultValue() {
        return 0L;
    }

    @Override
    Long value(Gauge metric) {
        return metric.getValue();
    }

    @Override
    public void recordValue(String name, long value) {
        this.getValueOperations().set((Object)this.getMetricKey(name), (Object)value);
    }

    @Override
    public void reset(String name) {
        this.getValueOperations().set((Object)this.getMetricKey(name), (Object)0L);
    }
}

