/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.integration;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.xd.analytics.metrics.core.FieldValueCounterRepository;
import org.springframework.xd.analytics.metrics.integration.AbstractMetricHandler;
import org.springframework.xd.tuple.Tuple;
import org.springframework.xd.tuple.integration.JsonToTupleTransformer;

public class FieldValueCounterHandler
extends AbstractMetricHandler {
    private final FieldValueCounterRepository fieldValueCounterRepository;
    private final String fieldName;
    private final JsonToTupleTransformer jsonToTupleTransformer;

    public FieldValueCounterHandler(FieldValueCounterRepository fieldValueCounterRepository, String nameExpression, String fieldName) {
        super(nameExpression);
        Assert.notNull((Object)fieldValueCounterRepository, (String)"FieldValueCounterRepository can not be null");
        Assert.hasText((String)fieldName, (String)"Field name can not be null or empty string");
        this.fieldValueCounterRepository = fieldValueCounterRepository;
        this.fieldName = fieldName;
        this.jsonToTupleTransformer = new JsonToTupleTransformer();
    }

    @ServiceActivator
    public Message<?> process(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof String) {
            try {
                payload = this.jsonToTupleTransformer.transformPayload(payload.toString());
            }
            catch (Exception e) {
                throw new MessageTransformationException(message, e.getMessage(), (Throwable)e);
            }
        }
        if (payload instanceof Tuple) {
            this.processTuple(this.computeMetricName(message), (Tuple)payload);
        } else {
            this.processPojo(this.computeMetricName(message), payload);
        }
        return message;
    }

    private void processPojo(String counterName, Object payload) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(payload);
        if (beanWrapper.isReadableProperty(this.fieldName)) {
            Object value = beanWrapper.getPropertyValue(this.fieldName);
            this.processValue(counterName, value);
        }
    }

    private void processTuple(String counterName, Tuple tuple) {
        String[] path = StringUtils.tokenizeToStringArray((String)this.fieldName, (String)".");
        this.processValueForCounter(counterName, tuple, path);
    }

    private void processValueForCounter(String counterName, Object value, String[] path) {
        String key = path[0];
        Object result = null;
        if (value instanceof List) {
            for (Object item : (List)value) {
                this.processValueForCounter(counterName, item, path);
            }
        } else if (value instanceof Tuple) {
            Tuple t = (Tuple)value;
            if (t.hasFieldName(key)) {
                result = t.getValue(key);
            }
        } else if (value instanceof Map) {
            result = ((Map)value).get(key);
        }
        if (result != null) {
            if (path.length == 1) {
                this.processValue(counterName, result);
            } else {
                path = Arrays.copyOfRange(path, 1, path.length);
                this.processValueForCounter(counterName, result, path);
            }
        }
    }

    protected void processValue(String counterName, Object value) {
        if (value instanceof Collection || ObjectUtils.isArray((Object)value)) {
            List<Object> c = value instanceof Collection ? (List<Object>)value : Arrays.asList(ObjectUtils.toObjectArray((Object)value));
            for (Object e : c) {
                this.fieldValueCounterRepository.increment(counterName, e.toString());
            }
        } else {
            this.fieldValueCounterRepository.increment(counterName, value.toString());
        }
    }
}

