/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoap11Fault;
import org.springframework.ws.soap.saaj.SaajSoapBody;
import org.springframework.ws.soap.saaj.SaajSoapFaultException;
import org.springframework.ws.soap.soap11.Soap11Body;
import org.springframework.ws.soap.soap11.Soap11Fault;

class SaajSoap11Body
extends SaajSoapBody
implements Soap11Body {
    private final boolean langAttributeOnSoap11FaultString;

    SaajSoap11Body(SOAPBody body, boolean langAttributeOnSoap11FaultString) {
        super(body);
        this.langAttributeOnSoap11FaultString = langAttributeOnSoap11FaultString;
    }

    public Soap11Fault getFault() {
        SOAPFault fault = this.getImplementation().getFault(this.getSaajBody());
        return fault != null ? new SaajSoap11Fault(fault) : null;
    }

    public Soap11Fault addFault(QName faultCode, String faultString, Locale faultStringLocale) {
        Assert.notNull((Object)faultCode, (String)"No faultCode given");
        Assert.hasLength((String)faultString, (String)"faultString cannot be empty");
        Assert.hasLength((String)faultCode.getLocalPart(), (String)"faultCode's localPart cannot be empty");
        Assert.hasLength((String)faultCode.getNamespaceURI(), (String)"faultCode's namespaceUri cannot be empty");
        if (!this.langAttributeOnSoap11FaultString) {
            faultStringLocale = null;
        }
        try {
            this.getImplementation().removeContents((SOAPElement)this.getSaajBody());
            SOAPFault saajFault = this.getImplementation().addFault(this.getSaajBody(), faultCode, faultString, faultStringLocale);
            return new SaajSoap11Fault(saajFault);
        }
        catch (SOAPException ex) {
            throw new SaajSoapFaultException(ex);
        }
    }

    public Soap11Fault addClientOrSenderFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_11.getClientOrSenderFaultName(), faultString, locale);
    }

    public Soap11Fault addMustUnderstandFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_11.getMustUnderstandFaultName(), faultString, locale);
    }

    public Soap11Fault addServerOrReceiverFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_11.getServerOrReceiverFaultName(), faultString, locale);
    }

    public Soap11Fault addVersionMismatchFault(String faultString, Locale locale) {
        return this.addFault(SoapVersion.SOAP_11.getVersionMismatchFaultName(), faultString, locale);
    }
}

