/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapMessageCreationException;
import org.springframework.ws.soap.SoapMessageFactory;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoapMessage;
import org.springframework.ws.soap.saaj.support.SaajUtils;
import org.springframework.ws.transport.TransportInputStream;

public class SaajSoapMessageFactory
implements SoapMessageFactory,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)SaajSoapMessageFactory.class);
    private MessageFactory messageFactory;
    private String messageFactoryProtocol;
    private boolean langAttributeOnSoap11FaulString = true;

    public SaajSoapMessageFactory() {
    }

    public SaajSoapMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void setLangAttributeOnSoap11FaulString(boolean langAttributeOnSoap11FaulString) {
        this.langAttributeOnSoap11FaulString = langAttributeOnSoap11FaulString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSoapVersion(SoapVersion version) {
        if (SaajUtils.getSaajVersion() >= 2) {
            if (SoapVersion.SOAP_11 == version) {
                this.messageFactoryProtocol = "SOAP 1.1 Protocol";
                return;
            } else {
                if (SoapVersion.SOAP_12 != version) throw new IllegalArgumentException("Invalid version [" + version + "]. Expected the SOAP_11 or SOAP_12 constant");
                this.messageFactoryProtocol = "SOAP 1.2 Protocol";
            }
            return;
        } else {
            if (SoapVersion.SOAP_11 == version) return;
            throw new IllegalArgumentException("SAAJ 1.1 and 1.2 only support SOAP 1.1");
        }
    }

    public void afterPropertiesSet() throws Exception {
        block10: {
            if (this.messageFactory == null) {
                try {
                    if (SaajUtils.getSaajVersion() >= 2) {
                        if (!StringUtils.hasLength((String)this.messageFactoryProtocol)) {
                            this.messageFactoryProtocol = "SOAP 1.1 Protocol";
                        }
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Creating SAAJ 1.3 MessageFactory with " + this.messageFactoryProtocol));
                        }
                        this.messageFactory = MessageFactory.newInstance((String)this.messageFactoryProtocol);
                        break block10;
                    }
                    if (SaajUtils.getSaajVersion() == 1) {
                        logger.info((Object)"Creating SAAJ 1.2 MessageFactory");
                        this.messageFactory = MessageFactory.newInstance();
                        break block10;
                    }
                    if (SaajUtils.getSaajVersion() == 0) {
                        logger.info((Object)"Creating SAAJ 1.1 MessageFactory");
                        this.messageFactory = MessageFactory.newInstance();
                        break block10;
                    }
                    throw new IllegalStateException("SaajSoapMessageFactory requires SAAJ 1.1, which was not found on the classpath");
                }
                catch (NoSuchMethodError ex) {
                    throw new SoapMessageCreationException("Could not create SAAJ MessageFactory. Is the version of the SAAJ specification interfaces [" + SaajUtils.getSaajVersionString() + "] the same as the version supported by the application server?", ex);
                }
                catch (SOAPException ex) {
                    throw new SoapMessageCreationException("Could not create SAAJ MessageFactory: " + ex.getMessage(), ex);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using MessageFactory class [" + this.messageFactory.getClass().getName() + "]"));
        }
    }

    public WebServiceMessage createWebServiceMessage() {
        try {
            return new SaajSoapMessage(this.messageFactory.createMessage(), this.langAttributeOnSoap11FaulString);
        }
        catch (SOAPException ex) {
            throw new SoapMessageCreationException("Could not create empty message: " + ex.getMessage(), ex);
        }
    }

    public WebServiceMessage createWebServiceMessage(InputStream inputStream) throws IOException {
        MimeHeaders mimeHeaders = this.parseMimeHeaders(inputStream);
        try {
            inputStream = this.checkForUtf8ByteOrderMark(inputStream);
            return new SaajSoapMessage(this.messageFactory.createMessage(mimeHeaders, inputStream));
        }
        catch (SOAPException ex) {
            String contentType = StringUtils.arrayToCommaDelimitedString((Object[])mimeHeaders.getHeader("Content-Type"));
            if (contentType.indexOf("startinfo") != -1) {
                contentType = contentType.replace("startinfo", "start-info");
                mimeHeaders.setHeader("Content-Type", contentType);
                try {
                    return new SaajSoapMessage(this.messageFactory.createMessage(mimeHeaders, inputStream), this.langAttributeOnSoap11FaulString);
                }
                catch (SOAPException e) {
                    // empty catch block
                }
            }
            throw new SoapMessageCreationException("Could not create message from InputStream: " + ex.getMessage(), ex);
        }
    }

    private MimeHeaders parseMimeHeaders(InputStream inputStream) throws IOException {
        MimeHeaders mimeHeaders = new MimeHeaders();
        if (inputStream instanceof TransportInputStream) {
            TransportInputStream transportInputStream = (TransportInputStream)inputStream;
            Iterator headerNames = transportInputStream.getHeaderNames();
            while (headerNames.hasNext()) {
                String headerName = (String)headerNames.next();
                Iterator headerValues = transportInputStream.getHeaders(headerName);
                while (headerValues.hasNext()) {
                    String headerValue = (String)headerValues.next();
                    StringTokenizer tokenizer = new StringTokenizer(headerValue, ",");
                    while (tokenizer.hasMoreTokens()) {
                        mimeHeaders.addHeader(headerName, tokenizer.nextToken().trim());
                    }
                }
            }
        }
        return mimeHeaders;
    }

    private InputStream checkForUtf8ByteOrderMark(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 3);
        byte[] bom = new byte[3];
        if (pushbackInputStream.read(bom) != -1 && (bom[0] != -17 || bom[1] != -69 || bom[2] != -65)) {
            pushbackInputStream.unread(bom);
        }
        return pushbackInputStream;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("SaajSoapMessageFactory[");
        buffer.append(SaajUtils.getSaajVersionString());
        if (SaajUtils.getSaajVersion() >= 2) {
            buffer.append(',');
            buffer.append(this.messageFactoryProtocol);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

