/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.PasswordCallback;
import com.sun.xml.wss.impl.callback.UsernameCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.ws.soap.security.callback.AbstractCallbackHandler;

public class SpringUsernamePasswordCallbackHandler
extends AbstractCallbackHandler {
    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof UsernameCallback) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && authentication.getName() != null) {
                UsernameCallback usernameCallback = (UsernameCallback)callback;
                usernameCallback.setUsername(authentication.getName());
                return;
            }
            this.logger.warn((Object)"Cannot handle UsernameCallback: Spring Security SecurityContext contains no Authentication");
        } else if (callback instanceof PasswordCallback) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && authentication.getName() != null) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                passwordCallback.setPassword(authentication.getCredentials().toString());
                return;
            }
            this.logger.warn((Object)"Canot handle PasswordCallback: Spring Security SecurityContext contains no Authentication");
        }
        throw new UnsupportedCallbackException(callback);
    }
}

