/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.client.support;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.xml.transform.TransformerObjectSupport;

public abstract class WebServiceAccessor
extends TransformerObjectSupport
implements InitializingBean {
    private WebServiceMessageFactory messageFactory;
    private WebServiceMessageSender[] messageSenders;

    public WebServiceMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public WebServiceMessageSender[] getMessageSenders() {
        return this.messageSenders;
    }

    public void setMessageSender(WebServiceMessageSender messageSender) {
        Assert.notNull((Object)messageSender, (String)"'messageSender' must not be null");
        this.messageSenders = new WebServiceMessageSender[]{messageSender};
    }

    public void setMessageSenders(WebServiceMessageSender[] messageSenders) {
        Assert.notEmpty((Object[])messageSenders, (String)"'messageSenders' must not be empty");
        this.messageSenders = messageSenders;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.getMessageFactory(), (String)"Property 'messageFactory' is required");
        Assert.notEmpty((Object[])this.getMessageSenders(), (String)"Property 'messageSenders' is required");
    }

    protected WebServiceConnection createConnection(URI uri) throws IOException {
        Assert.notEmpty((Object[])this.getMessageSenders(), (String)"Property 'messageSenders' is required");
        WebServiceMessageSender[] messageSenders = this.getMessageSenders();
        for (int i = 0; i < messageSenders.length; ++i) {
            if (!messageSenders[i].supports(uri)) continue;
            WebServiceConnection connection = messageSenders[i].createConnection(uri);
            if (this.logger.isDebugEnabled()) {
                try {
                    this.logger.debug((Object)("Opening [" + connection + "] to [" + connection.getUri() + "]"));
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
            return connection;
        }
        throw new IllegalArgumentException("Could not resolve [" + uri + "] to a WebServiceMessageSender");
    }
}

